(* terms.mli *)

type term =
    Var of int
  | Prop of head * term list
and head =
    { name: string;
      mutable props: (term * term) list }
;;

value print_term : term -> unit
  and mymem : term -> term list -> bool
  and get : string -> head
  and add_lemma : term -> (term * term) list
;;
 
type binding = Bind of int * term
;;

value apply_subst : binding list -> term -> term
  and rewrite : term -> term
;;
