(* boyer.ml *)
(* Tautology checker *)

#open "terms";;
#open "rules";;

let truep x lst =
  match x with
    Prop(head, _) ->
      eq_string head.name "true" or mymem x lst
  | _ ->
      mymem x lst

and falsep x lst =
  match x with
    Prop(head, _) ->
      eq_string head.name "false" or mymem x lst
  | _ ->
      mymem x lst
;;

let rec tautologyp x true_lst false_lst =
 if truep x true_lst then true else
 if falsep x false_lst then false else
 match x with
     Var _ -> false
   | Prop (head,[test; yes; no]) as p ->
        if eq_string head.name "if" then
          if truep test true_lst then
            tautologyp yes true_lst false_lst
          else if falsep test false_lst then
            tautologyp no true_lst false_lst
          else tautologyp yes (test::true_lst) false_lst & 
               tautologyp no true_lst (test::false_lst)
        else
          false
;;

let tautp x = 
  let y = rewrite x in 
    tautologyp y [] [];;

(* the benchmark *)

let subst =
[Bind(23,
             Prop
              (get "f",
               [Prop
                (get "plus",
                 [Prop (get "plus",[Var 0; Var 1]);
                  Prop (get "plus",[Var 2; Prop (get "zero",[])])])]));
 Bind(24,
             Prop
              (get "f",
               [Prop
                (get "times",
                 [Prop (get "times",[Var 0; Var 1]);
                  Prop (get "plus",[Var 2; Var 3])])]));
 Bind(25,
             Prop
              (get "f",
               [Prop
                (get "reverse",
                 [Prop
                  (get "append",
                   [Prop (get "append",[Var 0; Var 1]);
                    Prop (get "nil",[])])])]));
 Bind(20,
             Prop
              (get "equal",
               [Prop (get "plus",[Var 0; Var 1]);
                Prop (get "difference",[Var 23; Var 24])]));
 Bind(22,
             Prop
              (get "lt",
               [Prop (get "remainder",[Var 0; Var 1]);
                Prop (get "member",[Var 0; Prop (get "length",[Var 1])])]))]
;;

let term =
           Prop
            (get "implies",
             [Prop
              (get "and",
               [Prop (get "implies",[Var 23; Var 24]);
                Prop
                (get "and",
                 [Prop (get "implies",[Var 24; Var 25]);
                  Prop
                  (get "and",
                   [Prop (get "implies",[Var 25; Var 20]);
                    Prop (get "implies",[Var 20; Var 22])])])]);
              Prop (get "implies",[Var 23; Var 22])])
;;

let main() =
  if tautp (apply_subst subst term) then
    print_string "\nProved!"
  else
    print_string "\nCannot prove!";
  print_newline()
;;

printexc__f main ();;
