/* Basic system calls */

#include <errno.h>
#include <fcntl.h>
#include <signal.h>
#include "../Include/z2k2.h"
#include "../Include/fail.h"
#include "signals.h"
#include "../Include/sys.h"

extern int errno;

extern int sys_nerr;
extern char *sys_errlist [];

unsigned char *error_message(void)
{
  if (errno < 0 || errno >= sys_nerr)
    return (unsigned char*)"unknown error";
  else
    return (unsigned char*)(sys_errlist[errno]);
}

void sys_error(void)
{
  raise_with_string(SYS_ERROR_EXN, error_message());
}

obj_t sys_exit(obj_t retcode)          /* ML */
{
#ifdef MONITOR_GC
  _report_execution_ends();
#endif
  exit(CINT(retcode));
}

#ifndef O_BINARY
#define O_BINARY 0
#endif
#ifndef O_TEXT
#define O_TEXT 0
#endif

static int convert_flag_list(obj_t list, int *flags)
{ int res = 0;

  while (CINT(list)) {
    res |= flags[CINT(FIELD(list, 0))];
    list = FIELD(list, 1);
  }
  return res;
}

static int sys_open_flags[] = {
  O_RDONLY, O_WRONLY, O_RDWR, O_APPEND, O_CREAT, O_TRUNC, O_EXCL,
  O_BINARY, O_TEXT
};

obj_t sys_open(obj_t path, obj_t flags, obj_t perm) /* ML */
{ int ret;

  ret =open(STRING(path),convert_flag_list(flags,sys_open_flags),CINT(perm));
  if (ret == -1) sys_error();
  return MLINT(ret);
}

obj_t sys_close(obj_t fd)             /* ML */
{ if (close(CINT(fd)) != 0) sys_error();
/*  return Atom(0); */
}

obj_t sys_remove(obj_t name)          /* ML */
{ int ret;

  ret = unlink(STRING(name));
  if (ret != 0) sys_error();
/*  return Atom(0);*/
}

obj_t sys_rename(obj_t oldname, obj_t newname) /* ML */
{
#ifdef HAS_RENAME
    if (rename(STRING(oldname), STRING(newname)) != 0) sys_error();
#else
  invalid_argument("sys_rename: not implemented");
#endif
/*  return Atom(0); */
}

obj_t sys_chdir(obj_t dirname)        /* ML */
{ 
  if (chdir(STRING(dirname)) != 0) sys_error();
/*  return Atom(0); */
}

extern char *getenv();

obj_t sys_getenv(obj_t var)           /* ML */
{ unsigned char *res;

  res = (unsigned char*)getenv(STRING(var));
  if (res == 0) {
    raise_with_tag(NOT_FOUND_EXN);
  }
  return alloc_string(strlen(res),res);
}

obj_t sys_command_line;

void sys_init(int argc, char *argv[])
{ int i;

  sys_command_line=vector_alloc(argc); /* on batit la ligne de commande */
  CPTR(sys_command_line)[0]=MLINT(argc+1);
  for (i=0; i<argc; i++)
    CPTR(sys_command_line)[i+1]=
      alloc_string(strlen(argv[i]),(unsigned char*)(argv[i]));
}

/* Handling of user interrupts */

extern obj_t sys_raise__fpbreak__fpexn__ck1();

sighandler_return_type intr_handler(int sig)
{ obj_t closure = tuple_alloc(1);

  signal (SIGINT, intr_handler);
  FIELD(closure,0) = KFUN(sys_raise__fpbreak__fpexn__ck1);
  signal_handler = closure;
  signal_number = 0;
  execute_signal();
}

obj_t sys_catch_break(obj_t onoff)    /* ML */
{
  if (CINT(onoff))
    signal(SIGINT, intr_handler);
  else
    signal(SIGINT, SIG_DFL);
/*  return Atom(0); */
}

/* Search path function */

/*char *searchpath(char *name)
{
  char fullname[1024];
  char * path;
  char * p;
  char * q;

  for (p = name; *p != 0; p++) {
    if (*p == '/') return name;
  }
  path = getenv("PATH");
  if (path == 0) return 0;
  while(1) {
    p = fullname;
    while (*path != 0 && *path != ':') {
      *p++ = *path++;
    }
    if (p != fullname) *p++ = '/';
    q = name;
    while (*q != 0) {
      *p++ = *q++;
    }
    *p = 0;
    if (access(fullname, 1) == 0) return fullname;
    if (*path == 0) return 0;
    path++;
  }
}*/


