/* strings.c */
/* operations sur les chaines */
/* version 0.5 */
/* Regis Cridlig 1991-1993 */

#include "../Include/z2k2.h"

/* create_string is handled by primitive: make_string */

obj_t compare_strings(obj_t s1,obj_t s2)  /* ML */
{ ulint len1, len2;
  register ulint len;
  register unsigned char *p1, *p2;

  len1 = CINT(STRING_LENGTH(s1));
  len2 = CINT(STRING_LENGTH(s2));
  for (len = (len1 <= len2 ? len1 : len2), 
         p1 = STRING(s1), 
         p2 = STRING(s2);
       len > 0;
       len--, p1++, p2++)
    if (*p1 != *p2)
      return (*p1 < *p2) ? MLINT(-1) : MLINT(1); 
  if (len1 == len2)
    return MLINT(0);
  else if (len1 < len2)
    return MLINT(-2);
  else
    return MLINT(2);
}

obj_t  /* ML */
blit_string(obj_t s1, obj_t offset1, obj_t s2, obj_t offset2, obj_t len)
{
  bcopy(&BYTE(s1, CINT(offset1)), &BYTE(s2, CINT(offset2)), CINT(len));
  /* return MLVOID; */
}

obj_t fill_string(obj_t s, obj_t offset, obj_t len, obj_t init) /* ML */
{ register unsigned char *p;
  register ulint n;
  register unsigned char c;

  c = CINT(init);
  for(p = &BYTE(s, CINT(offset)), n = CINT(len); n > 0; n--, p++) *p = c;
  /* return MLVOID; */
}

obj_t          /* ML */
get_vect16_item(obj_t s,obj_t n) /* suppose n=2*CINT(n) */ /* Bof !!! */
{ unsigned char *v=STRING(s);

  return MLINT(v[n]+((((signed char *)v)[n+1]) << 8));
}
