/* signals.c */
/* Gestion des signaux */
/* version 0.5 */
/* Regis Cridlig 1991-1993 */

#include <signal.h>
#include "../Include/z2k2.h"
#include "signals.h"
#include "../Include/fail.h"

volatile int signal_is_pending = 0;
int in_blocking_section = 0;
volatile obj_t signal_handler;
volatile int signal_number;

void execute_signal(void)
{
  if (in_blocking_section)
    CFUN(closure_fun(signal_handler))(signal_handler,MLINT(signal_number));
  else {
    signal_is_pending = 1;
  }
}

void enter_blocking_section(void)
{
  in_blocking_section = 1;
  if (signal_is_pending) execute_signal();
}

void leave_blocking_section(void)
{
  in_blocking_section = 0;
}

/*void init_signals(void)
{ pending_signal = MLINT(0);
  block_signals = 0;
  raise_on_signal = 0;
  bottom_exc=block_alloc(0);
  TAG(bottom_exc)=BOTTOM_EXN;
}*/

/*void raise_pending_signal(void)
{ obj_t exc;

  exc = pending_signal;
  pending_signal = MLINT(1);
  signal_is_pending = 0;
  raise_on_signal = 0;
  raise_with_tag(exc);
}*/

/*static void signal_handler(int sig)
{ 
#ifndef BSD_SIGNALS
  (void) signal (sig, signal_handler);
#endif
  if (block_signals) return;
  if (sig >= 0 && sig < CINT(VECSIZE(signal_table))) 
  { pending_signal = FIELD(signal_table, sig+1);
    signal_is_pending = 1;
    if (raise_on_signal)
      raise_pending_signal();
  }
}*/

/*obj_t set_signal(obj_t sig,obj_t behavior) / ML /
{ if (sig < MLINT(0)) {
    block_signals = (TAG(behavior) == MLINT(1));
  } else {
    switch(TAG(behavior)) {
    case MLINT(0):                       / Signal_default /
      signal(sig, SIG_DFL);
      VECFIELD(signal_table, sig) = bottom_exc;
      break;
    case MLINT(1):                       / Signal_ignore /
      signal(sig, SIG_IGN);
      VECFIELD(signal_table, sig) = bottom_exc;
      break;
    case MLINT(2):                       / Signal_raise /
      VECFIELD(signal_table, sig) = FIELD(behavior, 1);
      signal(sig, signal_handler);
      break;
    }
  }
  / return MLVOID; /
}*/
