/* io.c : entrees/sorties bufferisees */
/* version 0.5 */
/* Regis Cridlig 1991-1993 */

#include <fcntl.h>

#include "../Include/z2k2.h"
#include "io.h"
#include "signals.h"
#include "../Include/fail.h"

/* Fonctions communes entree/sortie */

obj_t open_descriptor(obj_t fd)        /* ML */
{ struct channel * channel;

#ifdef BOEHM
  channel = (struct channel *) gc_alloc_atomic(sizeof(struct channel));
#else
  { int length = (sizeof(struct channel)-1)/sizeof(obj_t)+2;
    obj_t *buf = (obj_t *)Allocate(length,OPAQUE_REG);

    *buf++ = MLINT(length);
    channel = (struct channel *)buf;
  }
#endif
  channel->fd = CINT(fd);
  channel->offset = 0;
  channel->curr = channel->max = channel->buff;
  channel->end = channel->buff + IO_BUFFER_SIZE;
  return MLPTR(channel);
}

obj_t channel_descriptor(obj_t chanl)   /* ML */
{ struct channel *channel = (struct channel *) CPTR(chanl);

  return MLINT(channel->fd);
}

extern long lseek(int, long, int);

obj_t channel_size(obj_t chanl)      /* ML */
{ long end;
  struct channel *channel = (struct channel *) CPTR(chanl);

  end = lseek(channel->fd, 0L, 2);
  if (end == -1) sys_error();
  if (lseek(channel->fd,channel->offset,0) != channel->offset) sys_error();
  return MLINT(end);
}

/******** Sorties *********/

void really_write(int fd, unsigned char *p, int n)
{ int retcode;

  while (n > 0) {
    retcode = write(fd, p, n);
    if (retcode == -1) sys_error();
    p += retcode;
    n -= retcode;
  }
}   

obj_t flush(obj_t chanl)            /* ML */
{ int n;
  struct channel *channel = (struct channel *) CPTR(chanl);

  n = channel->max - channel->buff;
  if (n > 0)
  { really_write(channel->fd, channel->buff, n);
    channel->offset += n;
    channel->curr = channel->max = channel->buff;
  }
/*   return MLVOID; */
}

obj_t output_char(obj_t chanl,obj_t ch)  /* ML */
{ struct channel *channel = (struct channel *) CPTR(chanl);

  putch(channel, CCHAR(ch));
  /* return MLVOID; */
}

void putword(struct channel *channel, slint w)
{
  putch(channel, (unsigned char)(w >> 24));
  putch(channel, (unsigned char)(w >> 16));
  putch(channel, (unsigned char)(w >> 8));
  putch(channel, (unsigned char)(w));
}

obj_t output_int(obj_t chanl, obj_t w)    /* ML */
{ struct channel *channel = (struct channel *) CPTR(chanl);

  putword(channel, CINT(w));
  /* return MLVOID; */
}

void putblock(struct channel *channel, unsigned char *p, slint n)
{ slint m;

  m = channel->end - channel->curr;
  if (channel->curr == channel->buff && n >= m) {
    really_write(channel->fd, p, n);
    channel->offset += n;
  } else if (n <= m) {
    bcopy(p, channel->curr, n);
    channel->curr += n;
    if (channel->curr > channel->max) channel->max = channel->curr;
  } else {
    bcopy(p, channel->curr, m);
    p += m;
    n -= m;
    m = channel->end - channel->buff;
    really_write(channel->fd, channel->buff, m);
    channel->offset += m;
    if (n <= m) {
      bcopy(p, channel->buff, n);
      channel->curr = channel->max = channel->buff + n;
    } else {
      really_write(channel->fd, p, n);
      channel->offset += n;
      channel->curr = channel->max = channel->buff;
    }
  }
}
  
obj_t output(obj_t chanl, obj_t buf, obj_t start, obj_t length) /* ML */
{ unsigned char *p;
  slint n;
  struct channel *channel = (struct channel *) CPTR(chanl);

  p = &BYTE(buf, CINT(start));
  n = CINT(length);
  putblock(channel,p,n);
  /* return MLVOID; */
}

obj_t seek_out(obj_t chanl, obj_t pos)    /* ML */
{
  slint dest;
  struct channel *channel = (struct channel *) CPTR(chanl);

  dest = CINT(pos);
  if (dest >= channel->offset &&
      dest <= channel->offset + channel->max - channel->buff) {
    channel->curr = channel->buff + dest - channel->offset;
  } else {
    flush(chanl);
    if (lseek(channel->fd, dest, 0) != dest) sys_error();
    channel->offset = dest;
  }
  /* return MLVOID; */
}

obj_t pos_out(obj_t chanl)        /* ML */  
{ struct channel *channel = (struct channel *) CPTR(chanl);

  return MLINT(channel->offset + channel->curr - channel->buff);
}

obj_t close_out(obj_t chanl)     /* ML */
{ struct channel *channel = (struct channel *) CPTR(chanl);

  flush(chanl);
  if (close(channel->fd) == -1) sys_error();
/*  free(channel); */
/*  return MLVOID; */
}

/* Entrees */

static int really_read(int fd, unsigned char *p, int n)
{ int retcode;

  enter_blocking_section();
  /*raise_on_signal = 1;          /* Pour ne pas rester bloque dans le read */
  /*if (signal_is_pending)        /* Si un signal s'est declenche entre */
  /*  raise_pending_signal();     /* le dernier STARTFUN et raise_on_signal=1*/
  retcode = read(fd, p, n);
  leave_blocking_section();
  /*raise_on_signal = 0;*/
  if (retcode == -1) sys_error();
  return retcode;
}

unsigned char refill(struct channel *channel)
{ int n;

  n = really_read(channel->fd, channel->buff, IO_BUFFER_SIZE);
  if (n == 0) raise_with_tag(END_OF_FILE_EXN);
  channel->offset += n;
  channel->max = channel->buff + n;
  channel->curr = channel->buff + 1;
  return channel->buff[0];
}

obj_t input_char(chanl)       /* ML */
{ struct channel *channel = (struct channel *) CPTR(chanl);
  unsigned char c;

  c = getch(channel);
  return MLCHAR(c);
}

slint getword(struct channel *channel)
{ int i;
  ulint res;

  res = 0;
  for(i = 0; i < 4; i++)
    res = (res << 8) + getch(channel);
  return (slint)res;
}

obj_t input_int(obj_t chanl)        /* ML */
{ struct channel *channel = (struct channel *) CPTR(chanl);

  return MLINT(getword(channel));
}

slint getblock(struct channel *channel, unsigned char *p, slint n)
{ slint m,l;

  m = channel->max - channel->curr;
  if (n <= m) {
    bcopy(channel->curr, p, n);
    channel->curr += n;
    return n;
  } else if (m > 0) {
    bcopy(channel->curr, p, m);
    channel->curr += m;
    return m;
  } else if (n < IO_BUFFER_SIZE) {
      l = really_read(channel->fd, channel->buff, IO_BUFFER_SIZE);
      channel->offset += l;
      channel->max = channel->buff + l;
      if (n > l) n = l;
      bcopy(channel->buff, p, n);
      channel->curr = channel->buff + n;
      return n;
    } else {
      l = really_read(channel->fd, p, n);
      channel->offset += l;
      return l;
    }
}  

obj_t input(obj_t chanl,obj_t buff,obj_t start,obj_t length) /* ML */
{ struct channel *channel = (struct channel *) CPTR(chanl);
  unsigned char *p;
  slint n;

  p = &BYTE(buff, CINT(start));
  n = CINT(length);
  return MLINT(getblock(channel,p,n));
}

obj_t seek_in(obj_t chanl, obj_t pos)     /* ML */
{ struct channel *channel = (struct channel *) CPTR(chanl);
  long dest;

  dest = CINT(pos);
  if (dest >= channel->offset - (channel->max - channel->buff) &&
      dest <= channel->offset) {
    channel->curr =  channel->max - (channel->offset - dest);
  } else {
    if (lseek(channel->fd, dest, 0) != dest) sys_error();
    channel->offset = dest;
    channel->curr = channel->max = channel->buff;
  }
  /* return MLVOID; */
}

obj_t pos_in(obj_t chanl)          /* ML */
{ struct channel *channel = (struct channel *) CPTR(chanl);

  return MLINT(channel->offset - (channel->max - channel->curr));
}

obj_t close_in(obj_t chanl)     /* ML */
{ struct channel *channel = (struct channel *) CPTR(chanl);

  if (close(channel->fd) == -1) sys_error();
/*  free(channel); */
/*  return MLVOID; */
}

