/* parser.c */
/* The PDA automaton for parsers generated by camlyacc */
/* version 0.5 */
/* Regis Cridlig 1992,1993 */

#include "../Include/z2k2.h"

struct parser_tables {   /* Mirrors parse_tables in ../Lib/parsing.mli */
  obj_t actions;
  obj_t transl;
  obj_t lhs;
  obj_t len;
  obj_t defred;
  obj_t dgoto;
  obj_t sindex;
  obj_t rindex;
  obj_t gindex;
  obj_t tablesize;
  obj_t table;
  obj_t check;
};

struct parser_env {       /* Mirrors parser_env in ../Lib/iparsing.mli */
  obj_t s_stack;
  obj_t v_stack;
  obj_t symb_start_stack;
  obj_t symb_end_stack;
  obj_t stacksize;
  obj_t curr_char;
  obj_t lval;
  obj_t symb_start;
  obj_t symb_end;
  obj_t sp;
  obj_t lhs_start;
  obj_t lhs_end;
  obj_t rule_number;
};

#ifdef BIG_ENDIAN /* defini dans config.h */
#define Short(tbl,n) \
  (*((unsigned char *)(STRING(tbl) + (n) * sizeof(short))) + \
          (*((signed char *)((tbl) + (n) * sizeof(short) + 1)) << 8))
#else
#define Short(tbl,n) (((short *)(STRING(tbl)))[n])
#endif

#ifdef DEBUG
int parser_trace = 0;
#define Trace(act) if(parser_trace) act
#else
#define Trace(act)
#endif

/* Input codes */

#define START MLINT(0)        /* Mirrors parser_input in ../lib/iparsing.mli */
#define TOKEN_READ MLINT(1)
#define STACKS_GROWN_1 MLINT(2)
#define STACKS_GROWN_2 MLINT(3)
#define SEMANTIC_ACTION_COMPUTED MLINT(4)

/* Output codes */

#define READ_TOKEN MLINT(0)  /* Mirrors parser_output in ../Lib/iparsing.mli */
#define RAISE_PARSE_ERROR MLINT(1)
#define GROW_STACKS_1 MLINT(2)
#define GROW_STACKS_2 MLINT(3)
#define COMPUTE_SEMANTIC_ACTION MLINT(4)

/* The pushdown automata */

obj_t parse_engine(struct parser_tables *tables, struct parser_env *env, 
		   obj_t cmd, obj_t arg)  /* ML */
{ static int state;
  static ulint sp;
  int n, n1, n2, m, state1;
  ulint sp2;

  switch(cmd) {

  case START:
    state = 0;
    sp = CINT(env->sp);

  loop:
    Trace(printf("Loop %d\n", state));
    n = Short(tables->defred, state);
    if (n != 0) goto reduce;
    if (CINT(env->curr_char) >= 0) goto testshift;
    return READ_TOKEN;
                            /* The ML code calls the lexer and updates */
                            /* symb_start and symb_end */
  case TOKEN_READ:
    env->curr_char = VECFIELD(tables->transl, TAG(arg));
    if (obj_size(arg) == 0) {
      env->lval = CINT(0);
    } else {
      env->lval = FIELD(arg, 1);
    }
    Trace(printf("Token %d (0x%lx)\n", CINT(env->curr_char), env->lval));
    
  testshift:
    n1 = Short(tables->sindex, state);
    n2 = n1 + CINT(env->curr_char);
    if (n1 != 0 && n2 >= 0 && n2 <= CINT(tables->tablesize) &&
        Short(tables->check, n2) == CINT(env->curr_char)) goto shift;
    n1 = Short(tables->rindex, state);
    n2 = n1 + CINT(env->curr_char);
    if (n1 != 0 && n2 >= 0 && n2 <= CINT(tables->tablesize) &&
        Short(tables->check, n2) == CINT(env->curr_char)) {
      n = Short(tables->table, n2);
      goto reduce;
    }
    return RAISE_PARSE_ERROR;
                                /* The ML code raises the Parse_error exn */
  shift:
    state = Short(tables->table, n2);
    Trace(printf("Shift %d\n", state));
    sp++;
    if (sp < CINT(env->stacksize)) goto push;
    return GROW_STACKS_1;
                                /* The ML code resizes the stacks */
  case STACKS_GROWN_1:
  push:
    FIELD(env->s_stack, sp+1) = MLINT(state);
    FIELD(env->v_stack, sp+1) = env->lval;
    FIELD(env->symb_start_stack, sp+1) = env->symb_start;
    FIELD(env->symb_end_stack, sp+1) = env->symb_end;
    env->curr_char = MLINT(-1);
    goto loop;

  reduce:
    Trace(printf("Reduce %d\n", n));
    sp2 = sp - Short(tables->len, n) + 1;
    env->lhs_start = FIELD(env->symb_start_stack, sp2+1);
    env->lhs_end = FIELD(env->symb_end_stack, sp+1);
    env->sp = MLINT(sp);
    env->rule_number = MLINT(n);
    sp = sp2;
    m = Short(tables->lhs, n);
    state1 = CINT(FIELD(env->s_stack, sp - 1 + 1));
    n1 = Short(tables->gindex, m);
    n2 = n1 + state1;
    if (n1 != 0 && n2 >= 0 && n2 <= CINT(tables->tablesize) &&
        Short(tables->check, n2) == state1) {
      state = Short(tables->table, n2);
    } else {
      state = Short(tables->dgoto, m);
    }
    if (sp < CINT(env->stacksize)) goto semantic_action;
    return GROW_STACKS_2;
                                /* The ML code resizes the stacks */
  case STACKS_GROWN_2:
  semantic_action:
    return COMPUTE_SEMANTIC_ACTION;
                              /* The ML code calls the semantic action */
  case SEMANTIC_ACTION_COMPUTED:
    FIELD(env->s_stack, sp+1) = MLINT(state);
    FIELD(env->v_stack, sp+1) = arg;
    FIELD(env->symb_end_stack, sp+1) = env->lhs_end;
    goto loop;
  }
}
