/* meta.c */

#include "../Include/z2k2.h"
#include "../Include/fail.h"

obj_t obj_size(obj_t v)  /* ML */ 
/* retourne la taille-1 de l'objet, suppose alloue */
{ int reg;

  if IS_INT(v)
    failwith((unsigned char*)"obj_size: not an allocated object");
  switch(reg=region(v)) {
  case STRING_REG:
    return MLINT((CINT(STRING_LENGTH(v))-1)/sizeof(obj_t)+1);
  case FLOAT_REG:
    return MLINT(1);
  case STD_HIDDEN_REG:
    return MLINT(0);
  case VEC_REG:
  case OPAQUE_REG:
    return VECSIZE(v);
  default:
    return MLINT(reg-OFFSET_REG-1);
  }
}

obj_t obj_is_block(register obj_t v)  /* ML */ 
/* retourne true si l'objet est alloue, false sinon */
{
  return IS_INT(v) ? KFALSE : KTRUE;
}

obj_t  obj_block(obj_t tag,obj_t size) /* ML */
/* alloue un bloc tagge de taille size+1 */
{
  obj_t res;
  ulint sz, i;
  slint tg;

  sz = CINT(size);
  tg = CINT(tag);
  if (sz == 0) return atom(tg);
  sz++;
#ifdef BOEHM
  res=gc_alloc(sz*sizeof(obj_t));
#else
  { val_t buf;
    F_AllocateSmall(sz,OFFSET_REG+sz,buf);
    res=(obj_t)buf+1;
  }
#endif
  FIELD(res,0)=tg;
  for (i = 1; i < sz; i++)
    FIELD(res,i)=MLINT(0);
  return res;
}

