/* io.h : entrees/sorties bufferisees */

#ifndef IO_BUFFER_SIZE
#define IO_BUFFER_SIZE 4096 /* was 8192 */
#endif

struct channel {
  int fd;	                /* Descripteur de fichier UNIX */
  long offset;                  /* Offset du buffer ds le fichier Unix */
  unsigned char *curr;                  /* Position courante dans le buffer */
  unsigned char *max;                   /* Fin logique du buffer */
  unsigned char *end;                   /* Fin physique du buffer */
  unsigned char buff[IO_BUFFER_SIZE];   /* Le buffer lui-meme */
};

/* Pour un buffer en ecriture:
     offset est la position absolue du debut du buffer (buff).
   Pour un buffer en lecture:
     offset est la position absolue de la fin du buffer (max).  */

#define putch(channel, ch)                                                    \
  { if ((channel)->curr >= (channel)->end) flush(MLPTR(channel));             \
    *((channel)->curr)++ = (ch);                                              \
    if ((channel)->curr > (channel)->max) (channel)->max = (channel)->curr; }

#define getch(channel)                                                        \
  ((channel)->curr >= (channel)->max ?  refill(channel) : *((channel))->curr++)

extern obj_t open_descriptor(obj_t);
extern obj_t flush(obj_t);
extern void putword(struct channel *, slint);
extern void putblock(struct channel *, unsigned char *, slint);
extern unsigned char refill(struct channel *);
extern slint getword(struct channel *);
extern slint getblock(struct channel *, unsigned char *, slint);
/*extern obj_t input(obj_t,obj_t,obj_t,obj_t);
  extern obj_t output(obj_t,obj_t,obj_t,obj_t);*/

#define INTEXTERN_MAGIC_NUMBER 0x9386B7C5L
