/* ints.c */
/* version 0.5 */
/* Regis Cridlig 1991-1993 */

#include "../Include/z2k2.h"

obj_t int_of_string(obj_t s)           /* ML */
{ slint res;
  int sign, base;
  unsigned char *p = STRING(s);
  int c,d;

  if (*p == '-') 
  { sign = -1;
    p++;
  } 
  else sign = 1;
  base = 10;
  if (*p == '0') {
    switch (p[1]) {
    case 'x': case 'X':
      base = 16; p += 2; break;
    case 'o': case 'O':
      base = 8; p += 2; break;
    case 'b': case 'B':
      base = 2; p += 2; break;
    }
  }
  res = 0;
  while (1) {
    c = *p;
    if (c >= '0' && c <= '9')
      d = c - '0';
    else if (c >= 'A' && c <= 'F')
      d = c - 'A' + 10;
    else if (c >= 'a' && c <= 'f')
      d = c - 'a' + 10;
    else break;
    if (d >= base) break;
    res = base * res + d;
    p++;
  }
  if (*p)
    failwith((unsigned char*)"int_of_string");
  return MLINT(sign < 0 ? -res : res);
}

obj_t format_int(obj_t fmt, obj_t arg)     /* ML */
{
  unsigned char format_buffer[32];
  int prec;
  unsigned char *p;
  unsigned char *dest;
  obj_t res;

  prec = 32;
  for (p = STRING(fmt); *p != 0; p++) {
    if (*p >= '0' && *p <= '9') {
      prec = atoi(p) + 5;
      break;
    }
  }
  if (prec <= sizeof(format_buffer)) {
    dest = format_buffer;
  } else {
    dest = (unsigned char *)malloc(prec); /* bof ! */
  }
  sprintf(dest, STRING(fmt), CINT(arg));
  res = alloc_string(strlen(dest),dest);
  if (dest != format_buffer) {
    free(dest);
  }
  return res;
}
