/* intext.c : entrees/sorties structurees */
/* version 0.5 */
/* Regis Cridlig 1992,1993 */

#include "../Include/z2k2.h"
#include "io.h"
#include "../Include/fail.h"

#define SHARE_REG  STD_FREE_REG /* 1+64 */
#define INT_REG    STD_GM_REG   /* 2+64 */
#define OBJ_MAX 10000 /* a changer si trop faible */
#define CONST_MAX 10000 /* a changer si trop faible */

struct sharing
{ unsigned int next;
  obj_t objs[OBJ_MAX];
};

static void emit(struct channel *chan,obj_t v,struct sharing *sh)
{ int reg;
  ulint i,len;

 again:
  if (IS_INT(v))
    { putch(chan,'B');
      putword(chan,CINT(v));
      return;
    }
  reg=region(v);
  if (reg==STD_HIDDEN_REG)
    { putch(chan,'@');
      putch(chan,CCHAR(TAG(v)));
      return;
    }
  for(i=0; i<sh->next; i++)
    if (v==(sh->objs)[i])
      { putch(chan,'A');
	putword(chan,i);
	return;
      }
  putch(chan,(unsigned char)(reg+64));
  if (sh->next == OBJ_MAX)
    failwith((unsigned char*)"extern: too many objects");
  (sh->objs)[(sh->next)++] = v;
  switch(reg)
  { case STRING_REG:
      len = CINT(STRING_LENGTH(v));
      putword(chan,len);
      output(MLPTR(chan),v,MLINT(0),MLINT(len));
      return;
    case FLOAT_REG:
      for(i=0; i<8; i++)
	putch(chan,BYTE(v,i));
      return;
    case OPAQUE_REG:
      len = SIZE(v);
      putword(chan,len);
      output(MLPTR(chan),v,MLINT(sizeof(obj_t)),MLINT(sizeof(obj_t)*(len-1)));
      return;
    case VEC_REG:
      len = CINT(VECSIZE(v));
      putword(chan,len);
      for(i=1; i<len; i++)
	emit(chan,FIELD(v,i),sh);
      v = FIELD(v,len); 
      goto again;    /* tail-recursion */
    default:
      len = reg-OFFSET_REG-1;
      for(i=0; i<len; i++)
	emit(chan,FIELD(v,i),sh);
      v = FIELD(v,len); 
      goto again;    /* tail-recursion */
  }
}

obj_t extern_val(obj_t chanl,obj_t v)       /* ML */
{ struct channel * chan = (struct channel *) CPTR(chanl);
  struct sharing share;

  putword(chan, INTEXTERN_MAGIC_NUMBER);
  share.next = 0; /* initialisation */
  emit(chan,v,&share);
/*  return MLVOID; */
}

#define MEMO(v) {if (sh->next == OBJ_MAX)                       \
		   failwith((unsigned char*)"intern: too many objects");   \
		 (sh->objs)[(sh->next)++] = v;}

static obj_t intern(struct channel *chan,struct sharing *sh)
{ int reg = getch(chan)-64;
  ulint len,i;
  obj_t res;
  val_t ptr;

  switch(reg)
  { case STD_HIDDEN_REG:                         /* 0 */
      return MLPTR(constants+getch(chan));
    case SHARE_REG:                              /* 1 */
      return (sh->objs)[getword(chan)];
    case INT_REG:                                /* 2 */
      return MLINT(getword(chan));
    case STRING_REG:                             /* 6 */
      len = getword(chan);
      res = make_string(len);
      input(MLPTR(chan),res,MLINT(0),MLINT(len));
      BYTE(res,len)='\0';
      MEMO(res);
      return res;
    case FLOAT_REG:                              /* 8 */
      F_AllocateSmall(2,FLOAT_REG,ptr);
      res = MLPTR(ptr);
      for(i=0; i<8; i++)
	BYTE(res,0) = getch(chan);
      MEMO(res);
      return res;
    case OPAQUE_REG:                             /* 25 */
      len = getword(chan);
      res = MLPTR(Allocate(len,OPAQUE_REG));
      TAG(res) = MLINT(len--);
      input(MLPTR(chan),res,MLINT(sizeof(obj_t)),MLINT(sizeof(obj_t)*len));
      MEMO(res);
      return res;
    case VEC_REG:                                /* 7 */
      len = getword(chan);
      res = make_vector(len,MLINT(0));
      MEMO(res);
      for(i=1; i<=len; i++)
	FIELD(res,i) = intern(chan,sh);
      return res;
    default:                                     /* 9 a 24 */
      len = reg-OFFSET_REG;
      res = tuple_alloc(len);
      for(i=0; i<len; i++)
	FIELD(res,i) = MLINT(0);
      MEMO(res);
      for(i=0; i<len; i++)
	FIELD(res,i) = intern(chan,sh);
      return res;
  }
}

obj_t intern_val(obj_t chanl)          /* ML */
{ struct channel *chan = (struct channel *) CPTR(chanl);
  struct sharing share;

  if (getword(chan) != INTEXTERN_MAGIC_NUMBER)
    failwith((unsigned char*)"intern: bad object");
  share.next=0;
  return intern(chan,&share);
}

obj_t intern_const(unsigned char *s)
{ struct channel chanl;
  struct sharing share;

  share.next=0;
  chanl.curr=s;
  chanl.max=s+CONST_MAX;
  return intern(&chanl,&share);
}
