/* hash.c */
/* version 0.5 */
/* Regis Cridlig 1991-1993 */

#include "../Include/z2k2.h"

static ulint hash_accu, hash_univ_limit, hash_univ_count;

#define ALPHA 65599
#define BETA 19
#define COMBINE(new)  (hash_accu = hash_accu * ALPHA + (new))
#define COMBINE_SMALL(new) (hash_accu = hash_accu * BETA + (new))
#define CHECK_COUNT() {if (--hash_univ_count == 0) return;}
#define CHECK_LIMIT() {if (--hash_univ_limit == 0) return;}

static void hash_aux(obj_t obj)
{ unsigned char * p;
  ulint i;
  int reg;

  CHECK_LIMIT();

  if IS_INT(obj)
  { CHECK_COUNT();
    COMBINE((long) obj);
  }
  else
    switch(reg=region(obj)) {
    case STRING_REG:
      CHECK_COUNT();
      for(p = STRING(obj), i = CINT(STRING_LENGTH(obj)); i--; )
        COMBINE_SMALL(*p++);
      break;
    case FLOAT_REG:
      CHECK_COUNT();
      COMBINE(FIELD(obj,1)); /* a commenter si float */
      COMBINE(FIELD(obj,0));
      break;
    case OPAQUE_REG:
      CHECK_COUNT();
      i = SIZE(obj);
      while (--i != 0)
        COMBINE(FIELD(obj, i));
      break;
    case STD_HIDDEN_REG:
      CHECK_COUNT();
      COMBINE(obj);
      break;
    case VEC_REG:
      i = CINT(VECSIZE(obj));
      while (--i != 0)
        hash_aux(FIELD(obj, i));
      break;
    default:
      i = reg-OFFSET_REG;
      while (i-- != 0)
	hash_aux(FIELD(obj,i));
      break;
    }
}

obj_t hash_univ_param(obj_t count,obj_t limit,obj_t obj) /* ML */
{
  hash_univ_limit = CINT(limit);
  hash_univ_count = CINT(count);
  hash_accu = 0;
  hash_aux(obj);
  return MLINT(hash_accu);
}
