/* Egalite structurelle de graphes. */
/* Inutile pour la varsion 0.4 */

/* L'algorithme est le suivant :
   Avant de comparer deux objets, on suit les pointeurs d'indirections.
   Puis on place un pointeur d'indirection de l'un vers l'autre.
   Enfin, on compare les champs deux a deux.

   Les pointeurs d'indirection sont places dans le premier champ de l'objet.
   Ils sont signales par un coloriage de l'objet.
   L'ancienne valeur du champ est placee dans la memoire temporaire.
*/

struct save_val {
  value obj;
  value val;
};

static int ran_out_of_mem;

static int graph_equal_aux (x, y)
     value x, y;
{
  header hx, hy;
  value w, z, *px, *py;
  struct save_val * saved;
  unsigned long i;

  if (x == y)
    return 1;
  if (!(IS_ALLOCATED(x) && IS_BLOCK(x) && IS_ALLOCATED(y) && IS_BLOCK(y)))
    return 0;

  hx = HEADER (x);
  hy = HEADER (y);

  if (TAG_HDR (hx) != TAG_HDR (hy))
    return 0;

  switch (TAG_HDR (hx)){

  case TAG_STRING:
    return (compare_strings(x, y) == 0);

  case TAG_FLOAT:
    return (CFLOAT(x) == CFLOAT(y));

  case TAG_BITVECT:
    for(i = SIZE_HDR(hx), px = POINTER(x), py = POINTER(y);
        i > 0;
        i--, px++, py++)
      if (*px != *py) return 0;
    return 1;
  default:

    z = x;
    while(IS_FORWARDED(x))
      x = FIELD(x, 0);
    while(z != x) {
      w = FIELD(z, 0);
      FIELD(z, 0) = x;
      z = w;
    }
    z = y;
    while(IS_FORWARDED(y))
      y = FIELD(y, 0);
    while(z != y) {
      w = FIELD(z, 0);
      FIELD(z, 0) = y;
      z = w;
    }
    if (x == y)
      return 1;

    saved = (struct save_val *) temp_alloc(sizeof(struct save_val));
    if (saved == 0) {
      ran_out_of_mem = 1;
      return 1;
    }
    saved->obj = x;
    saved->val = FIELD(x, 0);
    FIELD(x, 0) = y;
    PUT_FORWARD_FLAG(x);
    for (i = SIZE_HDR(hx) - 1; i >= 1; i--)
      if (!graph_equal_aux(FIELD(x, i), FIELD(y, i)))
        return 0;
    return graph_equal_aux(saved->val, FIELD(y, 0));
  }
}

static struct save_val * start_of_saved_values;

static void clean_graph_equal ()
{
  struct save_val *i;

  for(i = (struct save_val *) temp_alloc(0) - 1;
      i >= start_of_saved_values;
      i--) {
    FIELD (i->obj, 0) = i->val;
    REMOVE_FORWARD_FLAG (i->obj);
  }
  temp_free ();
}


value graph_equal (x, y)        /* ML */
     value x, y;
{
  int result;

  start_of_saved_values = (struct save_val *) temp_alloc (0);
  ran_out_of_mem = 0;
  result = graph_equal (x, y);
  clean_graph_equal ();
  if (result && ran_out_of_mem)
    system_failwith_out_of_memory();
  return atom(result);
}
