/* floats.c */
/* version 0.5 */
/* Regis Cridlig 1991-1993 */

#include "../Include/z2k2.h"
#include "../Include/fail.h"

obj_t format_float(obj_t fmt, obj_t arg)    /* ML */
{ unsigned char format_buffer[64];
  int prec, i;
  unsigned char *p;
  unsigned char *dest;
  obj_t res;

  prec = 64;
  for (p = STRING(fmt); *p != 0; p++) {
    if (*p >= '0' && *p <= '9') {
      i = atoi(p) + 15;
      if (i > prec) prec = i;
      break;
    }
  }
  for( ; *p != 0; p++) {
    if (*p == '.') {
      i = atoi(p+1) + 15;
      if (i > prec) prec = i;
      break;
    }
  }
  if (prec <= sizeof(format_buffer)) {
    dest = format_buffer;
  } else {
    dest = (unsigned char*)malloc(prec); /* bof ! */
  }
  sprintf(dest, STRING(fmt), CFLOAT(arg));
  res = alloc_string(strlen(dest),dest);
  if (dest != format_buffer) {
     free(dest);
  }
  return res;
}

obj_t float_of_string(obj_t s)   /* ML */
{ extern double atof();

  return alloc_float(atof(STRING(s)));
}

obj_t exp_float(obj_t f)   /* ML */
{
  return alloc_float(exp(CFLOAT(f)));
}

obj_t log_float(obj_t f)   /* ML */
{
  return alloc_float(log(CFLOAT(f)));
}

obj_t sqrt_float(obj_t f)   /* ML */
{
  return alloc_float(sqrt(CFLOAT(f)));
}

obj_t power_float(obj_t f,obj_t g)    /* ML */
{
  return alloc_float(pow(CFLOAT(f), CFLOAT(g)));
}

obj_t sin_float(obj_t f)   /* ML */
{
  return alloc_float(sin(CFLOAT(f)));
}

obj_t cos_float(obj_t f)   /* ML */
{
  return alloc_float(cos(CFLOAT(f)));
}

obj_t tan_float(obj_t f)   /* ML */
{
  return alloc_float(tan(CFLOAT(f)));
}

obj_t asin_float(obj_t f)   /* ML */
{
  return alloc_float(asin(CFLOAT(f)));
}

obj_t acos_float(obj_t f)   /* ML */
{
  return alloc_float(acos(CFLOAT(f)));
}

obj_t atan_float(obj_t f)   /* ML */
{
  return alloc_float(atan(CFLOAT(f)));
}

obj_t atan2_float(obj_t f,obj_t g)   /* ML */
{
  return alloc_float(atan2(CFLOAT(f), CFLOAT(g)));
}
