/* Levee d'exceptions depuis C */
/* version 0.5 */
/* Regis Cridlig 1991-1993 */

#include "../Include/z2k2.h"
#include "../Include/fail.h" /* definitions des tags d'exceptions courants */

void mlraise(obj_t v)
{
  __cktry__ck=1;
  __ContinueValue=v;
  longjmp(CCONT(__ckhandle__ck), 1);
}

void raise_with_tag(obj_t tag)
{  mlraise(tag);
}
 
void raise_with_arg(obj_t tag, obj_t arg)
{ obj_t block=block_alloc(1);
  obj_t *ptr=CPTR(block);
  
  *ptr=tag;
  ptr[1]=arg;
  mlraise(block);
}

inline void raise_with_string(obj_t tag, unsigned char *msg)
{ raise_with_arg(tag,alloc_string(strlen(msg),msg));
}

void failwith(unsigned char *msg)
{
  raise_with_string(FAILURE_EXN, msg);
}

void invalid_argument(unsigned char *msg)
{
  raise_with_string(INVALID_EXN, msg);
}

void raise_out_of_memory(void)
{
  raise_with_tag(OUT_OF_MEMORY_EXN);
}

/*void os_error(void)
{ extern int errno;

  raise_with_arg(OS_EXN, (obj_t)errno);
}*/

/*obj_t division_by_zero(void)
{
  raise_with_tag(ZERO_DIVIDE_EXN);
}*/
