/* equal.c */
/* version 0.5 */

#include "../Include/z2k2.h"

/* Egalite structurelle d'arbres.
   Ne termine pas sur les structures cycliques. */

obj_t tree_equal(obj_t v1,obj_t v2) /* ML */
{
  ulint i;
  int reg;
  obj_t * p1, * p2;

 again:
  if (v1 == v2) return KTRUE;
  if (IS_INT(v1) || IS_INT(v2))
    return KFALSE;
  if ((reg=region(v1)) != region(v2)) return KFALSE;
  switch(reg) {
  case STRING_REG:
    return eq_strings(v1,v2);
  case FLOAT_REG:
    return (CFLOAT(v1) == CFLOAT(v2));
  case STD_HIDDEN_REG:
    return KFALSE;
  case VEC_REG:
    p1 = CPTR(v1);
    p2 = CPTR(v2);
    if ((i = CINT(*p1)) != CINT(*p2)) return KFALSE;
    for(; i > 2; i--)
      if (!tree_equal(*++p1, *++p2)) return KFALSE;
    v1 = *p1;
    v2 = *p2; 
    goto again;                  /* Recursion terminale */
  case OPAQUE_REG:
    p1 = CPTR(v1);
    p2 = CPTR(v2);
    if ((i = CINT(*p1)) != CINT(*p2)) return KFALSE;
    for(; i > 1; i--)
      if (*++p1 != *++p2) return KFALSE;
    return KTRUE;
  default:
    p1 = CPTR(v1);
    p2 = CPTR(v2);
    i = reg-OFFSET_REG;
    for(; i > 1; i--)
      if (!tree_equal(*p1++, *p2++)) return KFALSE;
    v1 = *p1;
    v2 = *p2; 
    goto again;                  /* Recursion terminale */
  }
}

