(* The Caml Light linker. Command-line parsing. *)

#open "../Compiler/config";;
#open "../Compiler/misc";;
#open "link";;

let banner = "  Camlot: Linker v0.51 -- July 1993\n";;

let object_files = ref ([] : string list)
and exec_file = ref default_exec_name
and default_lib = ref "cautious"
;;

let anonymous s =
  let name =
    if filename__check_suffix s ".ml" then
      filename__chop_suffix s ".ml"
    else
    if filename__check_suffix s ".o" then
      filename__chop_suffix s ".o"
    else raise (arg__Bad ("bad object suffix: " ^ s))
  in object_files := name :: !object_files
;;

let set_stdlib p =
  path_library := p;
  load_path := [!path_library]
and add_include d =
  load_path := d :: !load_path
and set_exec_file e =
  exec_file := e
and show_version () = prerr_string banner; exit 0
and open_set set =
    try
      default_lib := set
    with Not_found ->
      raise (arg__Bad ("unknown module set " ^ set))
;;

let main() =
try
  sys__catch_break true;
  load_path := [!path_library];
  arg__parse ["-stdlib", arg__String set_stdlib;
              "-I", arg__String add_include;
              "-include", arg__String add_include;
              "-O", arg__String open_set;
              "-o", arg__String set_exec_file;
              "-exec", arg__String set_exec_file;
              "-v", arg__Unit show_version;
              "-version", arg__Unit show_version;
              "-", arg__String anonymous]
             anonymous;
  link !default_lib (rev !object_files) !exec_file;
  exit 0

with Toplevel -> exit 2
   | sys__Break -> exit 3
   | arg__Bad s -> flush std_out;
                 prerr_string "# argument error : "; 
                 prerr_endline s;
                 exit 5
;;

printexc__f main ()
;;
