(* link.ml : batit le fichier main.k2 dans /tmp *)
(* version 0.5 *)
(* Regis Cridlig 1993 *)

#open "sys";;
#open "../Compiler/misc";;
#open "filename";;
#open "../Compiler/config";;

let std_modules = ["io"; "eq"; "int"; "float"; "pair"; "list";
                   "fvect"; "fchar"; "fstring"; "exc"; "stream";
                   "arg"; "filename"; "hashtbl"; "lexing"; "parsing"; 
                   "printexc"; "printf"; "queue"; "random"; "sort"; 
                   "stack"; "sys"]
;;

let default_used_implementations =
  ["none",     [];
   "fast",     std_modules;
   "cautious", std_modules @ ["vect"; "char"; "string"]]
;;

let link lib objects exec =
    let z2k2_main = path_tmp ^ "#camlot_" ^ (basename exec) in
    let main_k2 = open_out (z2k2_main ^ ".k2")
    and modules = assoc lib default_used_implementations in
    let out s = output_string main_k2 s
    in out "(:declaration \"#include \\\"";
       out path_include; out "z2k2.h\\\"\")\n";
       if not boehm then out "(:declare :static :defun gcvars ())\n";
       out "(:declare :static :defun objects ())\n";
       out "(:declaration \"#include \\\"";
       out path_include; out "main.h\\\"\")\n";
       if not boehm then
       begin out "(:defun gcvars ()\n";
             do_list (fun modu -> out "(vars_of_"; out modu; out ")\n") 
                     modules;
             do_list (fun obj -> out "(vars_of_"; 
                                 out (basename obj); 
                                 out ")\n") 
                     objects;
             out ")\n"
       end;
       out "(:defun objects ()\n";
       do_list (fun modu -> out "(init_of_"; out modu; out ")\n") modules;
       do_list (fun obj -> out "(init_of_"; out (basename obj); out ")\n") 
               objects;
       do_list (fun modu -> out "(main_of_"; out modu; out ")\n") modules;
       do_list (fun obj -> out "(main_of_"; out (basename obj); out ")\n") 
               objects;
       out "(io:exit*1 (:expression \"(obj_t)0\"))\n";
       out ")\n";
       close_out main_k2;
       print_string z2k2_main; print_newline ()
;;
