(* printexc.ml *)
(* A catch-all exception handler *)
(* version 0.5 *)
(* Regis Cridlig 1993 *)

#open "exc";;
#open "eq";;
#open "int";;
#open "fvect";;
#open "io";;
#open "obj";;
#open "sys";;

type qualid = {qual:string; id:string}
;;

let f fct arg =
  try
    fct arg
  with x ->
    flush std_out;
    begin match x with
      Out_of_memory ->
        prerr_string "Out of memory"
    | Sys_error msg ->
        prerr_string "System call failed : ";
        prerr_string msg
    | Failure s ->
        prerr_string "Evaluation failed : "; prerr_string s
    | Invalid_argument s ->
        prerr_string "Invalid argument : "; prerr_string s
    | End_of_file ->
        prerr_string "End of file encountered"
    | Division_by_zero ->
        prerr_string "Division by zero error"
    | Break ->
        prerr_string "Break exception"
    | Not_found ->
        prerr_string "Exception Not_found raised"
    | Parse_failure ->
        prerr_string "Parse failure"
    | Match_failure(file, first_char, last_char) ->
        prerr_string "Pattern matching failed, file ";
        prerr_string file;
        prerr_string ", chars "; prerr_int first_char;
        prerr_string "-"; prerr_int last_char
    | x ->
        let tag = if is_block(repr x) then obj_tag (repr x) else magic x in
          prerr_string "Uncaught exception ";
          prerr_string (string_of_int tag)
    end;
    prerr_char `\n`;
    io__exit 2
;;
