(* The run-time library for parsers generated by mlyacc *)

#open "obj";;
#open "lexing";;

(* The following functions can be called by user code *)

value symbol_start : unit -> int
  and symbol_end : unit -> int
        (* symbol_start and symbol_end are to be called in the action part
           of a grammar rule only. They return the position of the string that
           matches the left-hand side of the rule. symbol_start() returns
           the position of the first character; symbol_end() returns the
           position of the last character, plus one. The first character
           in a file is at position 0. *)
  and clear_parser : unit -> unit
        (* Empty the parser stack. Call it just after a parsing function
           has returned, to remove all pointers from the parser stack
           to structures that were built by semantic actions during parsing.
           This is optional, but lowers the memory requirements of the
           programs. *)
;;

(* The following definitions are used by the generated parsers only.
   They are not intended to be used by user programs. *)

type parse_tables =
  { actions : (unit -> obj) vect;
    transl : int vect;
    lhs : string;
    len : string;
    defred : string;
    dgoto : string;
    sindex : string;
    rindex : string;
    gindex : string;
    tablesize : int;
    table : string;
    check : string }
;;

exception yyexit of obj
      and Parse_error of (obj -> bool);;

value yyparse : parse_tables -> int -> (lexbuf -> 'a) -> lexbuf -> 'b
  and peek_val : int -> 'a;;
