(* Operations on vectors, without sanity checks.
   THIS INTERFACE IS UNSAFE: CALLING THESE FUNCTIONS WITH WRONG PARAMETERS
   CAN CRASH THE PROGRAM. *)

(* This module implements the same functions as the [vect] module,
   but does not perform bound checks on the arguments of the functions.
   The functions are therefore faster than those in the [vect] module,
   but calling these functions with incorrect parameters (that is,
   parameters that would cause the [Invalid_argument] exception to be raised
   by the corresponding functions in the [vect] module) can crash the
   program. *)

(* Special syntax to build a vector of length n, with elements e1, ..., en :
      [| e1; ... ; en |].     *)

value vect_length : 'a vect -> int = 1 "vect_length"
        (* Returns the length (number of elements) of the given vector. *)
;;
value vect_item : 'a vect -> int -> 'a = 2 "get_vect_item"
        (* "vect_item v n" returns element number n of vector v.
           The first element has number 0.
           The last element has number vect_length v - 1.
           Anything can happen if n is outside the range
           0 .. vect_length v - 1.
           Special syntax is provided: "v.(n)" can be written in place of
           "vect_item v n". *)
  and vect_assign : 'a vect -> int -> 'a -> unit = 3 "set_vect_item"
        (* "vect_assign v n x" physically modifies vector v, replacing
           element number n with element x.
           Anything can happen if n is outside the range
           0 .. vect_length v - 1.
           Special syntax is provided: "v.(n) <- x" can be written in place of
           "vect_assign v n x". *)
;;

value make_vect : int -> 'a -> 'a vect = 2 "make_vect"
        (* "make_vect n x" returns a fresh vector of length n,
           initialized with n pointers to element x. *)
  and make_matrix : int -> int -> 'a -> 'a vect vect
;;

value concat_vect : 'a vect -> 'a vect -> 'a vect
        (* "concat_vect v1 v2" returns a fresh vector containing the
           concatenation of vectors v1 and v2. *)
  and sub_vect : 'a vect -> int -> int -> 'a vect
        (* "sub_vect v start len" returns a fresh vector of length len,
           containing elements number start through start + len - 1
           of vector v.
           Anything can happen if start, len do not designate a
           valid subvector of v; that is, if start < 0, or len > 0, or
           start + len > vect_length v. *)
;;

value fill_vect : 'a vect -> int -> int -> 'a -> unit
        (* "fill_vect v ofs len x" physically modifies vector v,
           storing element x in elements number ofs through ofs + len - 1.
           Anything can happen if ofs, len do not designate
           a valid subvector of v. *)
  and blit_vect : 'a vect -> int -> 'a vect -> int -> int -> unit
        (* "blit_vect v1 o1 v2 o2 len" copies len elements
           from vector v1, starting at element number o1, to vector v2,
           starting at element number o2. Works correctly even if v1 and v2
           are the same vector, and the source chunk and destination chunk
           overlap.
           Anything can happen if o1, len do not designate a
           valid subvector of v1, or if o2, len do not designate a valid
           subvector of v2. *)
;;
value list_of_vect : 'a vect -> 'a list
        (* "list_of_vect v" returns the list of all elements of v, that is:
             [v.(0); v.(1); ...; v.(vect_length v - 1)]. *)
  and vect_of_list : 'a list -> 'a vect
        (* "vect_of_list l" returns a fresh vector containing the elements
           of list l. *)
;;
value do_vect : ('a -> 'b) -> 'a vect -> unit
        (* "do_vect f v" applies function f in turn to all elements of v:
              f v.(0); f v.(1); ...; f v.(vect_length v - 1). *)
  and map_vect : ('a -> 'b) -> 'a vect -> 'b vect
        (* "map_vect f v" applies function f to all elements of v, and builds
           a vector with the results returned by f:
              [| f v.(0); f v.(1); ...; f v.(vect_length v - 1) |]. *)
  and map_vect_list : ('a -> 'b) -> 'a vect -> 'b list
        (* "map_vect_list f v" applies function f to all elements of v,
           and builds a list with the results returned by f:
              [ f v.(0); f v.(1); ...; f v.(vect_length v - 1) ]. *)
;;
