(* String operations, without sanity checks.
   THIS INTERFACE IS UNSAFE: CALLING THESE FUNCTIONS WITH WRONG PARAMETERS
   CAN CRASH THE PROGRAM. *)

value string_length : string -> int = 1 "string_length"
        (* Returns the length (number of characters) of the given string. *)
;;
value nth_char : string -> int -> char = 2 "get_nth_char"
        (* "nth_char s n" returns character number n in string s.
           The first character is character number 0.
           The last character is character number string_length s - 1.
           Anything can happen if n is ouside the range
           0 .. (string_length s - 1). *)
  and set_nth_char : string -> int -> char -> unit = 3 "set_nth_char"
        (* "set_nth_char s n c" physically modifies string s,
           replacing character number n by character c.
           Anything can happen if n is ouside the range
           0 .. (string_length s - 1). *)
;;
value prefix ^ : string -> string -> string
        (* "s1 ^ s2" returns a fresh string containing the concatenation of
           strings s1 and s2. *)
  and sub_string : string -> int -> int -> string
        (* "sub_string s start len" returns a fresh string of length len,
           containing characters number start through start + len - 1
           of string s.
           Anything can happen if start, len do not designate a
           valid substring of s; that is, if start < 0, or len > 0, or
           start + len > string_length s. *)
;;
value create_string : int -> string = 1 "make_string"
        (* "create_string n" returns a fresh string of length n,
           containing random characters. *)
  and make_string : int -> char -> string
        (* "make_string n c" returns a fresh string of length n,
           initialized to the character c. *)
;;

value fill_string : string -> int -> int -> char -> unit
    = 4 "fill_string"
        (* "fill_string s start len c" physically modifies string s,
           replacing characters number start through start + len - 1
           by character c. String s is returned.
           Anything can happen if start, len do not designate
           a valid substring of s. *)
  and blit_string : string -> int -> string -> int -> int -> unit
    = 5 "blit_string"
        (* "blit_string s1 o1 s2 o2 len" copies len characters
           from string s1, starting at character number o1, to string s2,
           starting at character number o2. Works correctly even if s1 = s2
           and the source chunk and destination chunk overlap.
           Anything can happen if o1, len do not designate a
           valid substring of s1, or if o2, len do not designate a valid
           substring of s2. *)
  and replace_string : string -> string -> int -> unit
        (* "replace_string dest src start" copies all characters from string
           src into string dst, starting at offset start.
           Anything can happen if copying would overflow string dest. *)
;;
value eq_string : string -> string -> bool = 2 "=string"
  and neq_string : string -> string -> bool = 2 "<>string"
  and le_string : string -> string -> bool = 2 "<=string"
  and lt_string : string -> string -> bool = 2 "<string"
  and ge_string : string -> string -> bool = 2 ">=string"
  and gt_string : string -> string -> bool = 2 ">string"
;;

value string_for_read : string -> string
        (* Returns a copy of its argument, with special characters represented
           by escape sequences, following the lexical conventions of
           CAML Light. *)
;;
