(* Character operations, without sanity checks. *)

(* This module implements the same functions as the [char] module,
   but does not perform bound checks on the arguments of the functions.
   The functions are therefore faster than those in the [char] module,
   but calling these functions with incorrect parameters (that is,
   parameters that would cause the [Invalid_argument] exception to be raised
   by the corresponding functions in the [char] module) can crash the
   program. *)

value int_of_char : char -> int = 1 "identity"
        (* Returns the ASCII code of its argument *)
  and char_of_int : int -> char = 1 "identity"
        (* Returns the character with the given ASCII code.
           Anything can happen if the argument is
           outside the range 0..255. *)
  and char_for_read : char -> string
        (* Returns a string representing the given character,
           with special characters escaped following the lexical conventions
           of CAML Light. *)
;;
