(* Character operations, with sanity checks. *)

value int_of_char : char -> int = 1 "identity"
        (* Returns the ASCII code of its argument *)
  and char_of_int : int -> char
        (* Returns the character with the given ASCII code.
           Raises Invalid_argument "char_of_int" if the argument is
           outside the range 0..255. *)
  and char_for_read : char -> string
        (* Returns a string representing the given character,
           with special characters escaped following the lexical conventions
           of CAML Light. *)
;;
