/***************************************************************************
  Copyright (C) Nitsan Seniak 1989, 1990

  This file is part of the K2 compiler.
  Permission to copy this software, in whole or in part, to use this
  software for any lawful noncommercial purpose, and to redistribute
  this software is granted subject to the restriction that all copies
  made of this software must include this copyright notice in full.
  The author(s) makes no warranties or representations of any kind, either
  express or implied, including but not limited to implied warranties
  of merchantability or fitness for any particular purpose.
  All materials developed as a consequence of the use of this
  software shall duly acknowledge such use, in accordance with the usual
  standards of acknowledging credit in research.
 ***************************************************************************/ 

/**********************************************************************
 *                                                                    *
 *              LES TYPES DES LEXEMES ET FORMES SYNTAXIQUES           *
 *                                                                    *
 **********************************************************************
 *
 * Ce fichier d'en-tete contient les definitions des types qui servent
 * a representer les formes et les sous-formes syntaxiques.
 *
 **********************************************************************/


/***********************************************************************
 *
 *                 Les types de l'analyseur lexical
 *
 ***********************************************************************
 *
 *
 *	lex_variable	la representation brute d'une variable lue.
 *
 * Rappelons (cf. atoms.l) que les variables lues par l'analyseur
 * lexical sont internees dans une table de hash, et qu'on peut
 * faire "==" pour verifier que deux lex_variable portent le meme
 * nom.
 *
 **********************************************************************/

struct lex_variable {
     char *name;		/* Le nom de la variable. */
     char *cname;		/* Le nom C de la variable */
     int count;			/* Initialement 0 ; utilise pour l'alpha- */
				/* conversion. */
};

struct keyword {
     int token;
     char *text;
};


/**********************************************************************
 *
 * Les types de l'analyseur syntaxique
 *
 **********************************************************************
 *
 *
 *	coordinates	des coordonnees dans le texte source.
 *	form		une forme syntaxique.
 *	variable_ref	une reference a une variable, peut importe
 * 			l'endroit (liste d'arguments, let, setq,
 * 			reference en lecture...)
 *	function_ref	idem pour une fonction.
 *	block_ref	idem pour un bloc lexical.
 *	definition	forme interne d'un "(nom args corps)".
 *	binding		forme interne d'un "(var val)"
 *	sizing		forme interne d'un "(var int)"
 *	clause		forme interne d'un "(text* val)"
 *	XXX_s		une structure contenant les informations
 *			specifiques a la forme syntaxique XXX.
 *			
 **********************************************************************/


typedef struct form form;	/* Moins verbeux comme ca. */


/*
 * Corrdonnees dans le source.
 */

struct coordinates {
     int lineno, vlineno;	/* cf. l'analyseur */
     char *vname;		/* lexical. */
};


/*
 * References aux variables et fonctions.
 */

struct variable_ref {
     struct lex_variable *lexvar; /* La representation brute. */
     struct coordinates origin;	  /* L'endroit ou la variable a ete lue. */
     variable *var;		  /* Un objet "variable" attribue par */
};				  /* une passe resolvant les references. */

struct function_ref {
     struct lex_variable *lexvar; /* Idem */
     struct coordinates origin;	  /* Idem */
     function *fun;		  /* Idem */
};

struct block_ref {
     struct lex_variable *lexvar; /* idem */
     struct coordinates origin;	  /* idem */
     block *block;		  /* idem */
};


/*
 * Sous-formes
 */

struct definition {
     struct coordinates origin;
     struct function_ref *fref;	  /* La fonction definie. */
     list vrefs;		  /* Les arguments. */
     form *body;
};

struct binding {
     struct variable_ref *vref;
     form *val;
};

struct sizing {
     struct variable_ref *vref;
     int size;
};

struct clause {
     list texts;		  /* Une liste de textes */
     form *body;
};


/*
 * Les formes syntaxiques.
 */

struct block_i {
     struct block_ref *bref;
     form *body;
};

struct case_i {
     form *val;
     list clauses;
     form *def;
};

struct continue_i {
     form *cont;
     form *val;
};

struct expression_i {
     char *text;
     list args;
};

struct flet_i {
     list defs;
     form *body;
};

struct funcall_i {
     form *fun;
     list args;
};

struct if_i {
     form *test;
     form *iftrue;
     form *iffalse;
};

struct labels_i {
     list defs;
     form *body;
};

struct let_i {
     list binds;
     form *body;
};

struct stack_allocate_i {
     list sizes;
     form *body;
};

struct progn_i {
     list body;
};

struct return_from_i {
     struct block_ref *bref;
     form *val;
};

struct setq_i {
     struct variable_ref *vref;
     form *val;
};

struct statement_i {
     char *text;
     list args;
};

struct test_i {
     char *text;
     list args;
};

struct the_continuation_i {
     variable *contvar;
};

struct application_i {
     struct function_ref *fref;
     list args;
};

union any_i {

     struct variable_ref	*variable_i;
     struct function_ref	*function_i;

     struct block_i		block_i;
     struct case_i 		case_i;
     struct continue_i 		continue_i;
     struct expression_i 	expression_i;
     struct flet_i 		flet_i;
     struct funcall_i 		funcall_i;
     struct if_i 		if_i;
     struct labels_i 		labels_i;
     struct let_i 		let_i;
     struct stack_allocate_i    stack_allocate_i;
     struct progn_i 		progn_i;
     struct return_from_i	return_from_i;
     struct setq_i 		setq_i;
     struct statement_i 	statement_i;
     struct test_i 		test_i;
     struct the_continuation_i	the_continuation_i;
     struct application_i 	application_i;

};

struct form {
     struct coordinates origin;
     short tag;
     union any_i node;
};


typedef void *yystype;

#define YYSTYPE		yystype
