/***************************************************************************
  Copyright (C) Nitsan Seniak 1989, 1990

  This file is part of the K2 compiler.
  Permission to copy this software, in whole or in part, to use this
  software for any lawful noncommercial purpose, and to redistribute
  this software is granted subject to the restriction that all copies
  made of this software must include this copyright notice in full.
  The author(s) makes no warranties or representations of any kind, either
  express or implied, including but not limited to implied warranties
  of merchantability or fitness for any particular purpose.
  All materials developed as a consequence of the use of this
  software shall duly acknowledge such use, in accordance with the usual
  standards of acknowledging credit in research.
 ***************************************************************************/ 

/**********************************************************************
 *                                                                    *
 *			  UTILITAIRES                                 *
 *                                                                    *
 **********************************************************************/

/*
 * Le type booleen
 */

typedef enum { TRUE = 1, FALSE = 0 } boolean;


/*
 * Le type continuation
 */

typedef int cont;


/*
 * Les fonctions d'initialisation.
 */

extern void InitUtil(void);
extern void UtilPre(void);
extern void UtilPost(void);


/**********************************************************************
 *
 *                      Allocation temporaire
 *
 **********************************************************************
 *
 * Macros :
 *	NEW		alloue un objet temporaire.
 * 	PNEW		alloue un objet permanent.
 *
 **********************************************************************/

#define	NEW(type)		(type *)allocl(sizeof(type))
#define PNEW(type)		(type *)allocp(sizeof(type))

/*
 * Fonctions utilisees par les macros.
 */

extern void *allocl(unsigned);
extern void *allocp(unsigned);


/**********************************************************************
 *
 *                              Listes
 *
 **********************************************************************
 *
 * Types :
 * 
 *	cons_cell	sert a definir le type list.
 *	list		pointeur sur un doublet
 *
 * Macros :
 * 
 *	CAR, CDR, NIL	les usuelles
 *
 **********************************************************************/


typedef struct cons_cell *list;

struct cons_cell {
     void *car;
     list cdr;
};

extern list cons(void *, list);

#define CAR(l)			(((list)l)->car)
#define CDR(l)			(((list)l)->cdr)
#define NIL			0

extern list emptyq(void);
extern list addq(void *, list);
extern list qlist(list);
extern list addenv(void *, void *, list);
extern void *readenv(void *, list);
extern boolean memberp(void *, list);


/*
 * Copie de chaines de caracteres dans le tas temporaire
 */

extern char *sncopy(char *, int);
extern char *scopy(char *);


/*
 * Copie de chaines de caracteres dans le tas permanent
 */

extern char *pscopy(char *);


/**********************************************************************
 *
 *			  Tables de hashage
 *
 **********************************************************************
 *
 * Types :
 *
 * struct hash_cell	Cellule de table de hash
 * struct hash_table	L'objet table de hash
 *
 * Macros indiquant la classe d'allocation :
 *
 * H_GLOBAL		Globale a la compilation d'un programme
 * H_LOCAL		Locale a la compilation d'une fonction
 *
 **********************************************************************/

struct hash_cell {
     char *str;
     void *contents;
     struct hash_cell *next;
};

struct hash_table {
     unsigned size;
     unsigned class;
     struct hash_cell *(*cells)[];
};

#define	H_GLOBAL	1
#define H_LOCAL		2

extern struct hash_table *create_hash_table(int, int);
extern struct hash_cell *find(struct hash_table *, char *);
struct hash_cell *find_create(struct hash_table *, char *);



/**********************************************************************
 * 
 * Generation (affichage) de caracteres et de chaines de caracteres.
 *
 **********************************************************************
 *
 * Macros :
 *
 *	GENC		genere un caractere.
 * 	GENS		genere une chaine de caracteres.
 * 
 ***********************************************************************/

#define GENC(c)		putc(c, Out)
#define GENS(s)		fputs(s, Out)
