/***************************************************************************
  Copyright (C) Nitsan Seniak 1989, 1990

  This file is part of the K2 compiler.
  Permission to copy this software, in whole or in part, to use this
  software for any lawful noncommercial purpose, and to redistribute
  this software is granted subject to the restriction that all copies
  made of this software must include this copyright notice in full.
  The author(s) makes no warranties or representations of any kind, either
  express or implied, including but not limited to implied warranties
  of merchantability or fitness for any particular purpose.
  All materials developed as a consequence of the use of this
  software shall duly acknowledge such use, in accordance with the usual
  standards of acknowledging credit in research.
 ***************************************************************************/ 

/**********************************************************************
 *                                                                    *
 *	  LES TYPES REPRESENTANT VARIABLES, FONCTIONS ET BLOCS        *
 *                                                                    *
 **********************************************************************
 *
 * Ce fichier d'en-tete contient les definitions des types qui servent
 * a representer les objets "variable", "fonction" et "block". Ces objets
 * contiennent des informations calculees a divers moments de la
 * compilation ; ces moments sont indiques par les signes suivantes :
 *
 *	[c]		collecte d'informations (collect.c)
 *	[p]		propagation des informations (propagate.c)
 *	[g]		generation de code C (generation.c)
 *
 **********************************************************************/

struct variable {
     boolean mutated;		/* La variable est affectee. [c] */
     boolean reference;		/* La variable est de type *obj dans les */
				/* ou elle apparait libre. [c] */
     int level;			/* Niveau lexical. [c] */
     struct lex_variable *lexvar;
				/* Le lexeme d'origine de la variable. [c] */
     int suffix;		/* Un "suffixe" numerique permettant de */
				/* rendre le nom de la variable unique, */
				/* et calcule a partir du champ count */
				/* de la lex_variable correspondante. [c] */
};



/**********************************************************************
 *
 *                 Les statuts possibles d'une fonction
 *
 **********************************************************************
 *
 *	UNKNOWN		Statut inconnu ; normalement, apres la propagation,
 *			aucune fonction n'a de statut inconnu.
 *
 * 	ROOT		La fonction principale, celle definie par defun.
 *
 *	GLOBAL		Fonction a compiler comme une fonction C.
 *
 *	LABEL		Fonction a compiler comme un label (cf. le champ
 *			labelof de function).
 *
 *	DUMMY		Fonction jamais appelee...
 *
 **********************************************************************/

enum fun_status { ROOT, UNKNOWN, GLOBAL, LABEL, DUMMY };


/*
 * Type des continuations symboliques
 */

typedef void *scont;

#define UNKSCONT 	((scont)-2)  /* Continuation inconnue */
#define TERMSCONT	((scont)-1)  /* Continuation des appels terminaux */
#define DUMSCONT	((scont)0)   /* Continuation bidon des echappements */

#define UNKSCONTP(c)	(c == UNKSCONT)
#define TERMSCONTP(c)	(c == TERMSCONT)
#define DUMSCONTP(c)	(c == DUMSCONT)

/*
 * Un arc du graphe d'appel.
 */

struct edge {
     scont scont;
     struct function *fun;
};

struct function {
     int level;			/* Niveau lexical [c]. */
     struct lex_variable *lexvar;
				/* Idem que pour les variables. */
     int suffix;		/* Idem que pour les variables. */
     struct definition *def;	/* La definition de la fonction. [c] */
     list freevars;		/* La liste des variables libres au */
                                /* "premier niveau", ie sans compter */
				/* celles libres dans des fonctions */
				/* locales [c], puis la liste des */
				/* variables libres a tous les niveaux. [p] */
     list called;		/* La liste des arcs correspondant aux */
				/* fonctions locales appelees */
				/* au premier niveau. [c] */
     list sconts;		/* La liste des continuation symboliques */
				/* de la fonction et des fonctions qu'elle */
				/* appelle de facon terminale. [p] */
     list called_t;		/* La liste des fonctions appelees de */
				/* facon terminale. [p] */
     list called_n;		/* La liste des fonctions appelees de */
				/* facon non terminale */
     enum fun_status status;	/* Le statut de la fonction. [p]. */
     boolean continued;		/* La fonction est elle a continuation ? [c] */
     int callsno;		/* Nombre d'appels a la fonction. [p] */

     list labels;		/* Eventuellement, la liste des fonctions */
				/* qui sont des labels dans la fonction. [p] */
     struct function *labelof;	/* Eventuellement, la fonction dans laquelle */
				/* elle est un label. [p] */
     struct variable *contvar;	/* La variable dans laquelle doit etre */
				/* placee la continuation de la fonction, */
				/* si necessaire. Autrement, NULL. [c] */
     boolean generated;		/* Pour le pas integrer deux fois un label. */
     struct function *visitor;	/* Pour l'algorithme de parcours de graphe. */
     boolean visited;		/* Idem. */
};


struct block {
     struct function *fun;	/* La fonction associee au bloc. [c] */
     int label;			/* Le numero du label marquant la sortie */
				/* du bloc. [g] */
     cont cont;		        /* La continuation compile-time du bloc. */
     boolean used;		/* Le bloc est-il utilise ? */
};


typedef struct variable variable;
typedef struct function function;
typedef struct block block;
