/***************************************************************************
  Copyright (C) Nitsan Seniak 1989, 1990

  This file is part of the K2 compiler.
  Permission to copy this software, in whole or in part, to use this
  software for any lawful noncommercial purpose, and to redistribute
  this software is granted subject to the restriction that all copies
  made of this software must include this copyright notice in full.
  The author(s) makes no warranties or representations of any kind, either
  express or implied, including but not limited to implied warranties
  of merchantability or fitness for any particular purpose.
  All materials developed as a consequence of the use of this
  software shall duly acknowledge such use, in accordance with the usual
  standards of acknowledging credit in research.
 ***************************************************************************/ 

/**********************************************************************
 *                                                                    *
 *		 EXPORTATIONS DE LA COMMANDE DE COMPILATION           *
 *                                                                    *
 **********************************************************************/

/*
 * Unique type exporte : la structure destinee a recueillir des informations
 * sur la compilation.
 */

struct info_struct {
     int roots;			/* Fonctions forcement globales */
     int globals;		/* Fonctions locales globalisees */
     int labels;		/* Fonctions locales integrees */
     int bglobals;		/* Blocs globalises */
     int blabels;		/* Blocs integres */
     int calls;			/* Appels de fonctions globales ou locales */
     int lcalls;		/* Appels de fonctions locales */
     int gosubs;		/* Appels chers de fonctions locales */
     int args;			/* Nombre total de parametres passes */
				/* a des fonctions locales ou de blocs */
     int exits;			/* Nombre total d'echappements */
     int longjmps;		/* Nombre d'echappements par longjmp */
};

/*
 * Options de compilation.
 */

extern FILE *In;
extern FILE *Out;
extern FILE *Err;

extern char *InName;
extern char *OutName;
extern char *Me;
extern boolean Debug;
extern boolean Recover;
extern boolean Localize;
extern boolean SharpLine;
extern int OptimLevel;
extern boolean Verbose;
extern boolean Traditional;

/*
 * Autres variables.
 */

extern char *ObjType;
extern jmp_buf DefunExit;
extern boolean Error;
extern int GlobalFunctionsCount;
extern struct info_struct Infos;
extern struct hash_table *SymbolsTable;
extern struct hash_table *DeclareTable;

/*
 * Fonctions appelees par l'analyseur syntaxique.
 */

extern void CompileDefun(struct definition *);
extern void CompileDefvar(struct variable_ref *, int, int, char *);
extern void CompileDeclaration(char *, list, int, int, char *);
extern void FunPrototype(struct lex_variable *, int, int, int, int, char *);
extern void VarPrototype(struct lex_variable *, int, int, int, char *);
extern void InitPre(void);
extern void InitPost(void);


/**********************************************************************
 *
 *                     Macros pour le debugging
 *
 **********************************************************************
 *
 *    [S]DEBUG
 *	 inst1;
 *	 inst2;
 *	  ...
 *    [S]END
 *
 **********************************************************************/

#define DEBUG		if (Debug) { printf("\n==(debug)==>\n");
#define END		printf("\n<==(end)==\n"); }
#define SDEBUG		if (Debug) {
#define SEND		}

