/***************************************************************************
  Copyright (C) Nitsan Seniak 1989, 1990

  This file is part of the K2 compiler.
  Permission to copy this software, in whole or in part, to use this
  software for any lawful noncommercial purpose, and to redistribute
  this software is granted subject to the restriction that all copies
  made of this software must include this copyright notice in full.
  The author(s) makes no warranties or representations of any kind, either
  express or implied, including but not limited to implied warranties
  of merchantability or fitness for any particular purpose.
  All materials developed as a consequence of the use of this
  software shall duly acknowledge such use, in accordance with the usual
  standards of acknowledging credit in research.
 ***************************************************************************/ 

/**********************************************************************
 *                                                                    *
 *		      IDENTIFICATEURS                   	      *
 *                                                                    *
 **********************************************************************/

/*
 * Impression d'un temporaire.
 */

#define GENTMP(n)	{ GENC('_'); GENC('_'); \
			  if (n <= 9) GENC('0'+(n)); \
		       else if (n <= 99) {GENC('0'+(n)/10);GENC('0'+(n)%10);} \
			  else fprintf(Out, "%d", n); \
			}

/*
 * Conversion d'un nom Sqil en un nom C
 */

extern char *cname(char *);

/*
 * Impression de variables.
 */

void PrintLexVariable(struct lex_variable *);
extern void PrintVariableIdent(variable *);
extern void PrintFunctionIdent(function *);
extern void PrintFunctionLabel(function *);
extern void PrintVariableRefIdent(struct variable_ref *);
extern void PrintFunctionRefLabel(struct function_ref *);
extern void PrintFunctionRefIdent(struct function_ref *);


/*
 * Table des mots clefs C (cf. option -k)
 */

extern struct hash_table *CKeywordsTable;


/*
 * Fonction d'initialisation
 */

extern void InitIdent(void);
