/***************************************************************************
  Copyright (C) Nitsan Seniak 1989, 1990

  This file is part of the K2 compiler.
  Permission to copy this software, in whole or in part, to use this
  software for any lawful noncommercial purpose, and to redistribute
  this software is granted subject to the restriction that all copies
  made of this software must include this copyright notice in full.
  The author(s) makes no warranties or representations of any kind, either
  express or implied, including but not limited to implied warranties
  of merchantability or fitness for any particular purpose.
  All materials developed as a consequence of the use of this
  software shall duly acknowledge such use, in accordance with the usual
  standards of acknowledging credit in research.
 ***************************************************************************/ 

/**********************************************************************
 *                                                                    *
 *		      AFFICHAGE DES IDENTIFICATEURS                   *
 *                                                                    *
 **********************************************************************
 *
 * On suppose que le nom de la variable a imprimer comme identificateur
 * C contient au plus une occurrence du caractere ':',  sans quoi
 * l'identificateur obtenu n'est pas unique (ex : a::EC et a$).
 *
 **********************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <setjmp.h>
#include <ctype.h>
#include "util.h"
#include "objects.h"
#include "yystype.h"
#include "atoms.h"
#include "k2.h"
#include "ident.h"


extern void PrintVariableIdent(variable *);
extern void PrintFunctionIdent(function *);
static void PrintSpecialChar(unsigned char);
static void PrintSuffixedIdent(char *, int);
static void PrintGlobalIdent(char *);



/**********************************************************************
 *
 * 	Gestion des conflits de noms avec des mots-cles C
 *
 **********************************************************************/

#define CKEYWORDS	39	/* Nombre de mots cles. */

static char *ckeywords[CKEYWORDS] = 
{
     "auto", "break", "case", "char", "const", "continue", "default", "do",
     "double", "else", "enum", "extern", "float", "for", "goto", "if", 
     "int", "long", "register", "return", "short", "signed", "sizeof",
     "static", "struct", "switch", "typedef", "union", "unsigned", "void",
     "volatile", "while", "obj_t",  "KTRUE", "KFALSE", "KCONT", "CCONT", 
     "CFUN", "__ContinueValue"
};

struct hash_table *CKeywordsTable;


/**********************************************************************
 * 
 * Fonctions :
 *
 *	cname		conversion d'un nom Sqil en un nom C
 *
 * Les autres fonctions (PrintVariableIdent, PrintFunctionIdent,
 * PrintVariableRefIdent, PrintFunctionRefIdent) ne sont que des
 * utilitaires).
 *
 **********************************************************************/


char *cname(char *id)
{
     int l = 0;
     char *s = id;
     char c = *s;
     char *r, *p;

				/* Calcul de la longueur de l'ident. C */

     if (isdigit(c))		/* Exemple : 1foo */
       {
	    l += 4;
	    s++;
       }
     
     while ((c = *(s++)) != '\0')
       {
	    if (isalnum(c)) l++;
	    else if (c == ':') l++;
	    else l += 4;
       }
     

				/* Calcul de l'ident */
   
     p = r = allocl(l+1);
     s = id;
     c = *s;
     
     if (isdigit(c))
       {
	    *(p++) = '_';
	    *(p++) = '_';
	    *(p++) = (unsigned char)(c/16+'a');
	    *(p++) = (unsigned char)((unsigned)c%16+'a');
	    s++;
       }
     
     while ((c = *(s++)) != '\0')
       {
	    if (isalnum(c)) *(p++) = c;
	    else if (c == ':') *(p++) = '_';
	    else 
	      {
		   *(p++) = '_';
		   *(p++) = '_';
		   *(p++) = (unsigned char)(c/16+'a');
		   *(p++) = (unsigned char)((unsigned)c%16+'a');
	      }
       }

     *p = '\0';

     if (find(CKeywordsTable, r) != NULL)
       {
	    char *new_r;
	    
	    new_r = allocl(l+3);
	    strncpy(new_r, r, l);
	    r = new_r;

	    p = &(r[l]);
	    *(p++) = '_';
	    *(p++) = '_';
	    *(p++) = '\0';
       }

     return r;
}
     

static void PrintSuffixedIdent(char *cname, int suffix)
{
     GENS(cname);

     if (suffix != 0)
       {
	    GENC('_');
	    GENC('_');
	    if (suffix <= 9)
		 GENC((unsigned char)('0'+suffix));
	    else fprintf(Out, "%d", suffix);
       }
}


/*
 * Cas particuliers
 */

void PrintLexVariable(struct lex_variable *lexvar)
{
     GENS(lexvar->cname);	/* Variable ou fonction globale */
}

void PrintVariableRefIdent(struct variable_ref *vref)
{
     variable *var = vref->var;

     if (var == NULL)		/* Reference a une variable globale */
	  GENS(vref->lexvar->cname);
     else PrintVariableIdent(var);
}

void PrintFunctionRefIdent(struct function_ref *fref)
{
     function *fun = fref->fun;

     if (fun == NULL)		/* Reference a une fonction globale */
	  GENS(fref->lexvar->cname);
     else PrintFunctionIdent(fun);
}

extern void PrintFunctionRefLabel(struct function_ref *fref)
{
     function *fun = fref->fun;
     
     PrintFunctionLabel(fun);	/* fun ne peut pas etre NULL */
     				/* car pas de label de fonction */
     				/* inconnue */
}

extern void PrintVariableIdent(variable *var)
{
     struct lex_variable *lexvar = var->lexvar;

     PrintSuffixedIdent(var->lexvar->cname, var->suffix);
}

extern void PrintFunctionIdent(function *fun)
{
     PrintSuffixedIdent(fun->lexvar->cname, fun->suffix);
}

extern void PrintFunctionLabel(function *fun)
{
     PrintFunctionIdent(fun);
     GENS("__l");
}


/*
 * Fonction d'initialisation
 */

extern void InitIdent(void)
{
     int i;
     
     CKeywordsTable = create_hash_table(H_GLOBAL, 101);
     for (i = 0; i<CKEYWORDS; i++)
       {
	    find_create(CKeywordsTable, ckeywords[i]);
       }
}

