/***************************************************************************
  Copyright (C) Nitsan Seniak 1989, 1990

  This file is part of the K2 compiler.
  Permission to copy this software, in whole or in part, to use this
  software for any lawful noncommercial purpose, and to redistribute
  this software is granted subject to the restriction that all copies
  made of this software must include this copyright notice in full.
  The author(s) makes no warranties or representations of any kind, either
  express or implied, including but not limited to implied warranties
  of merchantability or fitness for any particular purpose.
  All materials developed as a consequence of the use of this
  software shall duly acknowledge such use, in accordance with the usual
  standards of acknowledging credit in research.
 ***************************************************************************/ 

/***************************************************************************
 *                                                                         *
 *                    EXPORTATIONS DE ANALYSEUR LEXICAL                    *
 *                                                                         *
 ***************************************************************************/

/*
 * Variables contenant la representation des valeurs booleennes, 
 * utilisees pour la generation de code.
 */

extern char *True_lit;
extern char *False_lit;

/*
 * Table des mots-clefs
 */

struct hash_table *KeywordsTable;

/*
 * Coordonnees dans le source.
 */

extern void PrintError(char *, int, int, char *);
extern char *VirtualInName;
extern int VirtualLineno;
extern int Lineno;

/*
 * Fin de fichier.
 */

extern boolean Eof;

/*
 * Variables et fonctions produites par de Lex et utilisees par Yacc.
 */

extern int yylex(void);
extern void yyerror(char *);
extern FILE *yyin;



/*
 * Fonction d'initialisation
 */

extern void InitLex(void);
