.TH K2 1 "22 Aout 91" "Ecole Polytechnique & INRIA Rocquencourt" ""
.SH NOM
k2 \- compile un fichier Sqil vers du C
.SH SYNOPSIS
.B k2
[ input ]
[ -o output ]
[ -s ]
[ -d ]
[ -r ]
[ -l ]
   [ -c nnn ]
[ -O nnn ]
[ -v ]
.SH DESCRIPTION
La commande \fIk2\fR compile un fichier de directives Sqil
en un programme ANSI C. 

Le compilateur K2 reconnait, en plus des directives Sqil (DEFUN et DEFVAR) et
des expression Sqil (BLOCK, CONTINUE, FLET, FUNCALL, FUNCTION, IF, LABELS,
LET, PROGN, RETURN-FROM, SETQ, STACK-ALLOCATE et THE-CONTINUATION), la
directive DECLARATION et les formes EXPRESSION, TEST, STATEMENT et CASE.

.SH IDENTIFICATEURS LIBRES
Le code C produit contient des references aux types, macros et variables
suivants :

.TP
.B \fIobj_t\fR
Le type des valeurs manipulees par K2.

.TP
.B "obj_t"\fIKTRUE\fR
Valeur "vrai".

.TP
.B "obj_t"\fIKFALSE\fR
Valeur "faux".

.TP
.B "obj_t"\fIKCONT\fR(jmp_buf)
Macro de conversion d'un "jmp_buf" C en un "obj_t".

.TP
.B "jmp_buf"\fICCONT\fR(obj_t)
Macro de conversion d'un "obj_t" en "jmp_buf" C.

.TP
.B "obj_t"\fIKFUN\fR(obj_t (*)())
Macro de conversion d'une adresse de fonction C en un "obj_t".

.TP
.B "(obj_t (*)())"\fICFUN\fR(obj_t)
Macro de conversion d'un "obj_t" en une adresse de fonction C.

.TP
.B "obj_t"\fI__ContinueValue\fR
Variable utilisee pour la compilation du CONTINUE.

.SH OPTIONS
.BI \fIinput\fR
est le fichier contenant le source K2 ; l'entree standard est prise
par defaut.

.BI \-o " output"
specifie un fichier recevant le code C produit ; la sortie standard est
prise par defaut.

.BI \-s
indique que le code produit doit contenir des directives "#line".

.BI \-d
specifie le mode "debug" ; inutile et meme nocif pour une utilisation
normale.

.BI \-r
indique que l'assembleur doit pratiquer une reprise sur erreur ; par
defaut, il s'arrete a la premiere erreur rencontree.

.BI \-l
indique que les messages d'erreur doivent contenir une localisation
plus precise de l'erreur dans le source, quand c'est possible.

.BI \-c " nnn"
specifie la valeur initiale du compteur utilise pour suffixer
les noms des fonctions locales compilees comme des fonctions globales C
(10000 par defaut).

.BI \-O " nnn"
specifie le degre d'optimisation dans la compilation des fonctions ("3" par
defaut). "0" signifie que tout appel de fonction sera toujours compile
comme un appel de fonction C. "1" signifie que seuls les appels auto-
recursifs terminaux sont compiles comme des sauts. "2" signifie que
certaines fonctions sont integrees, mais que toute fonction appelee au moins
une fois de facon non terminale ne peut pas etre integree. "3" signifie
le degre maximal d'optimisation, avec "cablage" de continuation dans
certaines fonctions. Cette option agit egalement sur la compilation des
blcos lexicaux.

.BI \-v
indique au compilateur qu'il doit afficher, apres la compilation, certaines
statistiques sur la compilation des fonctions et des blocs.

.SH IDENTIFICATION
.de VL
\\$2
..
Auteur: Nitsan Seniak,
LIX, Ecole Polytechnique, route de Saclay, 91128 PALAISEAU.
.SH SEE ALSO
gcc (1), indent (1), cb (1)

.SH FEATURES
La forme STACK-ALLOCATE est compilee exactement comme un LET.
