/* z2k2.h */
/* version 0.5 */
/* fichier a inclure en tete des objets Zinc->K2 */
/* Regis Cridlig 1991-1993 */

#ifndef _z2k2_
#define _z2k2_

/*#define BOEHM /* gc de boehm */
/*#define NOGC /* BOEHM doit etre defini dans ce cas */

#include <setjmp.h>
#include "config.h"
#include "public.h"

typedef slint obj_t; /* type uniforme = entier signe 32 bits */

#include "prims.h"

extern obj_t __ContinueValue;
extern obj_t __ckhandle__ck,__cktry__ck;

#define KCONT(x) ((obj_t)(x))
#define CCONT(x) (*(jmp_buf *)(x))
#define KFUN(x) ((obj_t)(x))
#define CFUN(x) (*(obj_t (*)())(x))

#define KFALSE MLINT(0)
#define KTRUE  MLINT(1)

#include <math.h>

extern obj_t constants[];

/* fonctions d'allocation */

#ifdef BOEHM
#ifndef NOGC
#include "/homes/rc136/Boehm/gc.h"
#endif

#else

#include "parametres.h"
#include "alloc.h"

#define STD_HIDDEN_REG   0
#define STD_FREE_REG     1
#define STD_GM_REG       2
#define UNTRACED_REG     3
#define AMBROOTS_REG     4
#define BITMAP_REG       5
#define STRING_REG       6
#define VEC_REG          7
#define FLOAT_REG        8
#define OFFSET_REG       8
#define OPAQUE_REG      25

extern npage_t DescOffset;

static inline int 
#ifdef __STDC__
region(obj_t v)
#else
region(v)
     obj_t v;
#endif
{ register npage_t pn = PageNum(v);

  if ( pn < DescOffset )             /* rajoute ad hoc pour constants[] */
          return STD_HIDDEN_REG;
  else return PageTag(pn).nregion;
}

extern int NGcVars;
extern obj_t *GcVars[];
#endif

/* codage des pointeurs DANS LE TAS */
#ifdef BOEHM
#define MLPTR(x) ((obj_t)(x))
#define CPTR(x) ((obj_t *)(x))
#else
#define MLPTR(x) ((obj_t)(x)+1)
#define CPTR(x) ((obj_t *)((x)-1))
#endif

#define KPTR(x) MLPTR(x)

/* Codage des entiers */
#ifdef BOEHM
#define MLINT(x)     ((obj_t)(x))
#define CINT(x)      ((slint)(x))
#else
#define MLINT(x)     ((obj_t)((x)<<1))
#define CINT(x)      ((slint)(x)>>1)
#endif

/* Codage des caracteres */ /* ils sont non-signes */
#ifdef BOEHM
#define MLCHAR(x)    ((obj_t)(x))
#define CCHAR(x)     ((unsigned char)CINT(x))
#else
#define MLCHAR(x)    ((obj_t)((x)<<1))
#define CCHAR(x)     ((unsigned char)CINT(x))
#endif

/* Codage des flottants */
#define CFLOAT(x)    (c_float(x))
#define MLFLOAT(x)   (alloc_float(x))

/* Codage des chaines */
#define STRING(s) ((unsigned char*)CPTR(s)+sizeof(obj_t))
#define STRING_LENGTH(s) TAG(s) /* c'est un obj_t */
#define BYTE(s,offset) (STRING(s)[offset])

/* divers */

#define MLVOID (obj_t)0

#define TAGP(v) ((int)v&1)
#define IS_INT(v) (!((int)v&1))

#define TAG(v) (*CPTR(v))
#define TAGORIMM(v) (IS_INT(v) ? v : *CPTR(v))

#define FIELD(v,offset) (CPTR(v)[offset])

#define SIZE(v) CINT(TAG(v))

#define VECSIZE(v) (TAG(v)-MLINT(1)) /* c'est un obj_t */

#define VECFIELD(v,mloffset) (CPTR(v)[CINT(mloffset)+1])

/* fonctions d'allocation generales */

#ifndef __GNUC__
# define inline
#endif

#ifdef BOEHM
extern obj_t freep;

static inline obj_t 
# ifdef __STDC__
gc_alloc(register int a)
# else
gc_alloc(a)
 register int a;
# endif
{
# ifdef NOGC
  register obj_t res=freep;

  freep+=a;
  return res;
# else
  return MLPTR(GC_malloc(a));
# endif
}

static inline obj_t
# ifdef __STDC__
gc_alloc_atomic(register int a)
# else
gc_alloc_atomic(a)
 register int a;
# endif
{ 
# ifdef NOGC  
  register obj_t res=freep;

  freep+= (a+3)&~3; /* conserve l'alignement */
  return res;
# else
  return MLPTR(GC_malloc_atomic(a));
# endif
}
#endif

static inline obj_t
#ifdef __STDC__
atom(register obj_t tag)
#else
atom(tag)
 register obj_t tag;
#endif
{
  return MLPTR(constants+CINT(tag));
}

static inline obj_t    /* sert aussi pour les blocs sans tag */
#ifdef __STDC__
tuple_alloc(register int len)
#else
env_alloc(len)
   register int len;
#endif
{                                   
#ifdef BOEHM
  return gc_alloc(len*sizeof(obj_t));
#else
  register val_t res;
  int region=OFFSET_REG+len;

  F_AllocateSmall(len,region,res);
  return MLPTR(res);
#endif
}

static inline obj_t
#ifdef __STDC__
closure_fun(register obj_t closure)
#else
closure_fun(closure)
 register obj_t closure;
#endif
{
  return *CPTR(closure);
}

/*static inline obj_t closure_env(register obj_t closure)
{
  return MLPTR(CPTR(closure)+1);
}*/

static inline obj_t
#ifdef __STDC__
block_alloc(register int len)
#else
block_alloc(len)
 register int len;
#endif
{
#ifdef BOEHM
  return gc_alloc((len+1)*sizeof(obj_t));
#else
  register val_t res;
  register int region;

  len++;
  region=OFFSET_REG+len;
  F_AllocateSmall(len,region,res);
  return MLPTR(res);
#endif
}

/* allocation des chaines */

static inline obj_t
#ifdef __STDC__
alloc_string(register int len, register unsigned char *s)
#else
alloc_string(len,s)
 register int len;
 register unsigned char* s;
#endif
{ if (!len) return atom(MLINT(0));
#ifdef BOEHM
  else { register obj_t buf = gc_alloc_atomic(len+sizeof(obj_t));
#else
  else { register val_t buf;
	 register int wlen = len/sizeof(obj_t)+2;
         /* on ajoute '\0' a la fin */
	 if (wlen>SmallSizeLimit)
	   buf = AllocateBig(wlen,STRING_REG);
	 else F_AllocateSmall(wlen,STRING_REG,buf);
#endif
	 *(obj_t *)buf = MLINT(len);
	 bcopy(s,(unsigned char*)buf+sizeof(obj_t),len+1);
	 return MLPTR(buf);
       }
}

static inline obj_t
#ifdef __STDC__
make_string(register ulint len)
#else
make_string(len)
 register ulint len;
#endif
{
  if (!len) return atom(MLINT(0));
#ifdef BOEHM
  else { register obj_t buf=gc_alloc_atomic(len+size_of(obj_t));
#else
  else { register val_t buf;
	 register ulint wlen = len/sizeof(obj_t)+2;
	  /* on garde de la place pour un cararactere '\0' en plus */
	 if (wlen>SmallSizeLimit)
	   buf=AllocateBig(wlen,STRING_REG);
	 else F_AllocateSmall(wlen,STRING_REG,buf);
#endif
     	 *(obj_t *)buf = MLINT(len);
	 return MLPTR(buf);
       }
}

static inline obj_t
#ifdef __STDC__
eqimm_strings(register ulint len, register unsigned char *p, register obj_t v)
#else
eqimm_strings(len,p,v)
  register ulint len;
  register unsigned char *p;
  register obj_t v;
#endif
{ if (len!=CINT(STRING_LENGTH(v)))
    return KFALSE;
  else { register unsigned char *q = STRING(v);
	 
	 while (len--)
	   if (*p++!=*q++)
	     return KFALSE;
	 return KTRUE;
       }
}

static inline obj_t eq_strings(register obj_t s1, register obj_t s2)
{ return eqimm_strings(CINT(STRING_LENGTH(s1)),STRING(s1),s2);
}

/* allocation des vecteurs */

static inline obj_t
#ifdef __STDC__
vector_alloc(register ulint len)
#else
vector_alloc(len)
 register ulint len;
#endif
{
  if (!len) return atom(MLINT(1));
#ifdef BOEHM
  else return gc_alloc((len+1)*sizeof(obj_t));
#else
  else { register val_t buf;	 

	 len++;
	 if (len>SmallSizeLimit)
	   buf=AllocateBig(len,VEC_REG);
	 else F_AllocateSmall(len,VEC_REG,buf)
	 return MLPTR(buf);
       }
#endif
}

static inline obj_t
#ifdef __STDC__
make_vector(register ulint len, register obj_t item)
#else
make_vector(len,item)
 register ulint len;
 register obj_t item;
#endif
{
  if (!len) return atom(MLINT(1));
#ifdef BOEHM
  else
    { register obj_t buf = gc_alloc((len+1)*sizeof(obj_t));
      register obj_t *ptr;
      register ulint i;

      ptr=(obj_t *)buf;
      *ptr++ = MLINT(len+1);
      for(i=0;i<len;i++) *ptr++=item;
      return buf;
    }
#else
  else
    { register val_t buf;	
      register obj_t *ptr;
      register ulint i=len+1;

      if (i>SmallSizeLimit)
        buf=AllocateBig(i,VEC_REG);
      else F_AllocateSmall(i,VEC_REG,buf)
      ptr=(obj_t *)buf;
      *ptr++ = MLINT(len+1);
      for(i=0;i<len;i++) *ptr++=item;
      return MLPTR(buf);
    }
#endif
}

/* vector safe operations */

#include "fail.h"

static inline obj_t 
#ifdef __STDC__
vector_item(register obj_t v, register obj_t j)
#else
vector_item(v, j)
 register obj_t v, j;
#endif
{ if (j<0 || j>=VECSIZE(v))
    invalid_argument((unsigned char*)"vect_item");
  else return VECFIELD(v,j);
}

static inline obj_t 
#ifdef __STDC__
vector_assign(register obj_t v, register obj_t j, register obj_t e)
#else
vector_assign(v, j, e)
 register obj_t v, j, e;
#endif
{ if (j<0 || j>=VECSIZE(v))
    invalid_argument((unsigned char*)"vect_assign");
  else return VECFIELD(v,j)=e;
}

/* allocation des nombres en virgule flottante */

static inline obj_t
#ifdef __STDC__
alloc_float(register double f) /* sizeof(double)==2*sizeof(obj_t) */
#else
alloc_float(f)
 register double f;
#endif
{ register val_t ptr;
#ifdef BOEHM
  ptr=gc_alloc_atomic(sizeof(double));
#else
  F_AllocateSmall(2,FLOAT_REG,ptr)
#endif
  *(double*)ptr=f;
  return MLPTR(ptr);
}

static inline double
#ifdef __STDC__
c_float(register obj_t obj)
#else
c_float(f)
 register obj_t obj;
#endif
{
  return *(double*)CPTR(obj);
}

#endif /* _z2k2_ */
