/* main.h */
/* version 0.5 */
/* fichier pour le linker K2->C */
/* Regis Cridlig 1991-1993 */

#include "./sys.h"

#ifndef BOEHM
/**********************************************************************
 * Parametres de la gestion memoire (cf parametres.h)
 **********************************************************************/

double  ExpansionFactor = EXPANSION_FACTOR;
npage_t MinExpansion =    MINIMUM_EXPANSION;
npage_t GCThreshold =     GCTHRESHOLD;
npage_t InitialNPages =   INITIAL_NPAGES;
extern int GCVerbose;
extern void *usrstack;
# ifdef MONITOR_GC
extern int _gc_monitor_time;
extern int _gc_monitor_locality;
# endif

/* Variables globales */

#define MAXGCVARS 5000   /* a augmenter s'il le faut */
int NGcVars=0;             /* nb variables a visiter */
obj_t *GcVars[MAXGCVARS];         /* tableau initial des racines */

#endif

#ifdef NOGC
obj_t freep;
#endif

obj_t __ContinueValue, __ckhandle__ck, __cktry__ck;
obj_t constants[256]; 
/* constants[0] & constants[1] servent aussi pour la chaine de 
   caracteres et le vecteur vides respectivement */
	
#ifdef __STDC__
extern obj_t io_exit__ck1(obj_t);
extern obj_t really_write(int,unsigned char*,int);
#else
extern obj_t io_exit__ck1();
extern obj_t really_write();
extern void init_signals();
#endif

void 
#ifdef __STDC__
main(int argc,char *argv[])
#else
main(argc,argv)
 int argc;
 char *argv[];
#endif
{
  int i;
  jmp_buf buf;

#ifdef BOEHM
# ifdef NOGC
  freep=(obj_t)malloc(20000000);
# else
  GC_dont_expand=1;
# endif
#else

  GCVerbose = 1;
# ifdef MONITOR_GC  
  _gc_monitor_time = 1;
  _gc_monitor_locality = 0;
# endif

  usrstack = (val_t)&buf;  /* fond de pile */
# ifdef MONITOR_GC
   _report_execution_begins(argv[0]);
# endif
/* variables ML visibles depuis C pouvant contenir des pointeurs racines */
    GcVars[NGcVars++]=&sys_command_line;
    gcvars();
    if (NGcVars>MAXGCVARS)
      { really_write(2,(unsigned char*)"NGcVars>MAXGCVARS\n",18);
	exit(1);
      }
    InitMemoryManager(InitialNPages);   /* initialize memory manager */
# ifdef MONITOR_GC
    _report_init_heap();
# endif
#endif

  for (i=0;i<256;i++) constants[i]=MLINT(i);
  sys_init(argc,argv);

  __cktry__ck=MLINT(0);
  if (setjmp(buf))
  { really_write(2,
      (unsigned char*)"fatal error in main: uncaught exception\n",33);
    io_exit__ck1(MLINT(1));
  }
  else { __ckhandle__ck=KCONT(buf);
	 objects();
	 io_exit__ck1(MLINT(0)); /* pour flusher les buffers */
       }
}
