/* $Header: /Nfs/radyr/usr11/rc136/Projet/GC/RCS/alloc.h,v 1.1 1992/09/03 21:14:21 rc136 Exp rc136 $ */
/* Auteur: Vincent Delacour (delacour@poly.polytechnique.fr) */


/**********************************************************************
 *                      Allocation des objets
 **********************************************************************/


/**********************************************************************
 * Exportations
 **********************************************************************/

extern val_t Allocate(nwords_t, nregion_t);
extern val_t AllocateBig(nwords_t, nregion_t); 
extern val_t AllocateSmall(nwords_t, nregion_t); 

extern void InitMemoryManager(npage_t);

/**********************************************************************/


/* Allocation rapide des petits objets dans une region *statique* */
/* (F comme fast) */
     
#define F_AllocateSmall(sz, nreg, res) \
         { \
              register val_t  new_ap; \
	      if (sz < OneWord) error("Mauvaise taille\n"); \
              res = StaticRegionAP(nreg); \
              if((new_ap = res + sz) > StaticRegionLimit(nreg)) \
                   res = AllocateSmall(sz, nreg); \
              else \
                   StaticRegionAP(nreg) = new_ap; \
         } \
 


/* Allocation rapide des petits objets. La region est indifferente. */
/* (M comme macro) */

#define M_AllocateSmall(sz, nreg, res) \
         { \
              register val_t  new_ap; \
              if (sz < OneWord) error("mauvaise taille\n"); \
              res = RegionAP(nreg); \
              if((new_ap = res + sz) > RegionLimit(nreg)) \
                   res = AllocateSmall(sz, nreg); \
              else \
                   RegionAP(nreg) = new_ap; \
         } \


/**********************************************************************
 * Controle de la consommation memoire
 **********************************************************************/

extern nwords_t FreeMem;


/**********************************************************************
 * Strategie de gestion de la memoire
 **********************************************************************/

extern npage_t MinExpansion;            /* expansion minimmum */
extern double ExpansionFactor;          /* facteur d'expansion souhaite */
extern npage_t GCThreshold;             /* palier du gc */
extern npage_t PagesSinceLastGC;        /* nb pages allouees depuis gc */
extern npage_t HeapSize;                /* nb pages d'objets */
