/* Module des regions : implementation des regions statiques */

/* importation des types du gestionnaire memoire */

#include "../Include/public.h"

/* Tableau des regions statiques */

region_t StaticRegions[] =
{
     {{HIDDEN_ZONE,NO_MODE,0},{HIDDEN_ZONE,NO_MODE,0},"STD_HIDDEN_REG",0,0,0,0,0},
     {{FREE_ZONE,NO_MODE,1},{FREE_ZONE,NO_MODE,1},"STD_FREE_REG",0,0,0,0,0},
     {{HIDDEN_ZONE,NO_MODE,2},{HIDDEN_ZONE,NO_MODE,2},"STD_GM_REG",0,0,0,0,0},
     {{GC_ZONE,NO_MODE,3},{GC_ZONE,NO_MODE,3},"UNTRACED_REG",0,0,0,0,0},
     {{GC_ZONE,NO_MODE,4},{GC_ZONE,NO_MODE,4},"AMBROOTS_REG",0,0,0,0,0},
     {{GC_ZONE,NO_MODE,5},{GC_ZONE,NO_MODE,5},"BITMAP_REG",0,0,0,0,0},
     {{FROM_COPY_OPAQUE_ZONE,STRING_MODE,6},{FROM_BIG_OPAQUE_ZONE,STRING_MODE,6},"STRING_REG",4096,1023,0,2,1024},
     {{FROM_COPY_ZONE,HEADER_MODE,7},{FROM_BIG_ZONE,HEADER_MODE,7},"VEC_REG",4096,1023,0,2,1024},
     {{FROM_FIX_OPAQUE_ZONE,W2_MODE,8},{FROM_BIG_OPAQUE_ZONE,W2_MODE,8},"FLOAT_REG",2048+2048/2,0,2,0,0},
     {{FROM_COPY_ZONE,W1_MODE,9},{FROM_BIG_ZONE,W1_MODE,9},"W1_REG",2048+2048/1+2048/32,0,1,0,0},
     {{FROM_COPY_ZONE,W2_MODE,10},{FROM_BIG_ZONE,W2_MODE,10},"W2_REG",4096,0,2,0,0},
     {{FROM_COPY_ZONE,SMALLSIZE_MODE,11},{FROM_BIG_ZONE,SMALLSIZE_MODE,11},"W3_REG",4096,0,3,0,0},
     {{FROM_COPY_ZONE,W4_MODE,12},{FROM_BIG_ZONE,W4_MODE,12},"W4_REG",4096,0,4,0,0},
     {{FROM_COPY_ZONE,SMALLSIZE_MODE,13},{FROM_BIG_ZONE,SMALLSIZE_MODE,13},"W5_REG",4096,0,5,0,0},
     {{FROM_COPY_ZONE,SMALLSIZE_MODE,14},{FROM_BIG_ZONE,SMALLSIZE_MODE,14},"W6_REG",4096,0,6,0,0},
     {{FROM_COPY_ZONE,SMALLSIZE_MODE,15},{FROM_BIG_ZONE,SMALLSIZE_MODE,15},"W7_REG",4096,0,7,0,0},
     {{FROM_COPY_ZONE,W8_MODE,16},{FROM_BIG_ZONE,W8_MODE,16},"W8_REG",4096,0,8,0,0},
     {{FROM_COPY_ZONE,SMALLSIZE_MODE,17},{FROM_BIG_ZONE,SMALLSIZE_MODE,17},"W9_REG",4096,0,9,0,0},
     {{FROM_COPY_ZONE,SMALLSIZE_MODE,18},{FROM_BIG_ZONE,SMALLSIZE_MODE,18},"W10_REG",4096,0,10,0,0},
     {{FROM_COPY_ZONE,SMALLSIZE_MODE,19},{FROM_BIG_ZONE,SMALLSIZE_MODE,19},"W11_REG",4096,0,11,0,0},
     {{FROM_COPY_ZONE,SMALLSIZE_MODE,20},{FROM_BIG_ZONE,SMALLSIZE_MODE,20},"W12_REG",4096,0,12,0,0},
     {{FROM_COPY_ZONE,SMALLSIZE_MODE,21},{FROM_BIG_ZONE,SMALLSIZE_MODE,21},"W13_REG",4096,0,13,0,0},
     {{FROM_COPY_ZONE,SMALLSIZE_MODE,22},{FROM_BIG_ZONE,SMALLSIZE_MODE,22},"W14_REG",4096,0,14,0,0},
     {{FROM_COPY_ZONE,SMALLSIZE_MODE,23},{FROM_BIG_ZONE,SMALLSIZE_MODE,23},"W15_REG",4096,0,15,0,0},
     {{FROM_COPY_ZONE,SMALLSIZE_MODE,24},{FROM_BIG_ZONE,SMALLSIZE_MODE,24},"W16_REG",4096,0,16,0,0},
     {{FROM_FIX_OPAQUE_ZONE,HEADER_MODE,25},{FROM_BIG_OPAQUE_ZONE,HEADER_MODE,25},"OPAQUE_REG",2048+2048/2,1023,0,2,1024},
};

/* tableau initial des pointeurs sur les regions */

region_t *(initial_pregions[]) = 
{
     &StaticRegions[0],
     &StaticRegions[1],
     &StaticRegions[2],
     &StaticRegions[3],
     &StaticRegions[4],
     &StaticRegions[5],
     &StaticRegions[6],
     &StaticRegions[7],
     &StaticRegions[8],
     &StaticRegions[9],
     &StaticRegions[10],
     &StaticRegions[11],
     &StaticRegions[12],
     &StaticRegions[13],
     &StaticRegions[14],
     &StaticRegions[15],
     &StaticRegions[16],
     &StaticRegions[17],
     &StaticRegions[18],
     &StaticRegions[19],
     &StaticRegions[20],
     &StaticRegions[21],
     &StaticRegions[22],
     &StaticRegions[23],
     &StaticRegions[24],
     &StaticRegions[25]
};

region_t **PRegions = initial_pregions;
nregion_t NRegions = 26;
int      NBadRegions = 3; /* Nb de regions a residu variable */

