/* $Header: /Nfs/radyr/usr11/rc136/Projet/GC/RCS/private.h,v 1.1 1992/09/03 21:14:21 rc136 Exp rc136 $ */
/* Auteur: Vincent Delacour (delacour@poly.polytechnique.fr) */

#ifndef NULL
#define NULL ((void*) 0)
#endif

/**********************************************************************
 * Erreurs,  avertissements,  points d'arret
 **********************************************************************/

extern void message(char *s);
extern void stop();
extern void error(char *s);


/**********************************************************************
 * Adressages,  constantes,  conversions
 **********************************************************************/

#define Words2Pages(nw) ((npage_t)(((nw) + OnePage - 1) / OnePage))

#define NPages(add) 	((npage_t)((((nbytes_t)(add))+PageSize-1)/PageSize))
#define PageStart(add)  ((val_t)((ulint)(add) & ~PageMask))

#define PageMask        (PageSize - 1)
#define RoundUpToPageSize(add) \
                        ((((ulint)(add)) + (PageSize - 1)) & (~PageMask))

#define PageAddress(pn) ((val_t)((pn) * PageSize))




/**********************************************************************
 * Parametres du processus
 **********************************************************************/

extern val_t EndMem;                    /* dernier 'break' connu */
extern npage_t EndPage;                 /* page de ce break */
extern npage_t MaxPages;                /* nb pages acceptable */
extern npage_t HeapSize;                /* nb pages propres au GM */

/**********************************************************************
 * Descripteurs de pages & acces
 **********************************************************************
 * NPDesc(np) : nombre de pages necessaires pour decrire np pages. 
 * ATTENTION : du fait de la multiplication prealable par
 * sizeof(pagedesc_t), le domaine de validite est plus petit que le
 * domaine du type 'ulint.
 **********************************************************************/


#define NPDesc(np)      (NPages((np - DescOffset) * sizeof(pagedesc_t)))


#define DescCapacity(desc_size) \
                   (((desc_size + DescOffset) * PageSize) / sizeof(pagedesc_t))

#define NoBloc                  NullPage

#define NextPage(np)            (PageDescs[(np)].next)
#define PreviousPage(np)        (PageDescs[(np)].prev)

#define PageTop(np)             (PageDescs[(np)].top)

#define NextBloc(nb)            NextPage((nb))
#define PreviousBloc(nb)        PreviousPage((nb))
#define BlocSize(nb)            (PageDescs[(nb)].bsize)
#define BlocHead(nb)            (PageDescs[(nb)].bhead)
#define BlocTOP(nb)             (PageDescs[(nb)].top)

/**********************************************************************
 * Acces aux regions
 **********************************************************************/


#define RegionTag(nreg)         (PRegions[(nreg)]->pagetag)
#define RegionTag_Big(nreg)     (PRegions[(nreg)]->bigtag)
#define RegionCopyTag(nreg)     (PRegions[(nreg)]->copytag)

#define RegionCost(nreg)        (PRegions[(nreg)]->cost)
#define RegionWaste(nreg)       (PRegions[(nreg)]->waste)

#define StaticRegionTag(nreg)   (StaticRegions[(nreg)].pagetag)
#define STD_FREE_PTAG           (StaticRegionTag(STD_FREE_REG))

#define PopBreak(nreg)          (PRegions[(nreg)]->popbreak)
#define StaticPopBreak(nreg)    (StaticRegions[(nreg)].popbreak)

#define ChangeRegion(pn, nreg)  (PageTag((pn)) = RegionTag((nreg)))

#define FreeBloc_P(pn)          ((PageTag((pn))).zone == FREE_ZONE)


         /*-------------------------------------------------
         | Fonctions non-exportees du gestionnaire memoire |
         -------------------------------------------------*/


/* - init - */

extern void     InitMM(npage_t npages); 


/**********************************************************************
 * Expansion du tas
 **********************************************************************
 * La fonction d'expansion est exportee a l'usage des fonctions
 * d'allocation de haut niveau,  ainsi que les codes de retour
 * possibles.
 **********************************************************************/

extern ulint ExpandHeap(npage_t*, npage_t, npage_t);


/* codes de retour */

#define EXP_SUCCESS             0
#define EXP_PROPOSAL            1
#define EXP_EBLOC               2
#define EXP_EMAX                3
#define EXP_EBRK                4

/* Caracterisation des solutions calculees par DescribeExpansionX() : IN_SAME
 * (utilisation du meme tableau des pages), IN_POOL (le nouveau tdp
 * est pris dans le pool courant), IN_BEGI (le nouveau tdp est pris
 * au debut de l'increment), IN_VOID (pas de solution).
 */

#define IN_SAME                0
#define IN_POOL                1
#define IN_BEGI                2
#define IN_VOID                3


/**********************************************************************
 * Interface du POOL
 **********************************************************************
 * Les fonctions d'extraction (PoolGetBloc) et d'insertion
 * (PoolPutFirst et PoolPutLast) maintiennent PoolSize.
 **********************************************************************/

extern npage_t  PoolGetBloc(npage_t sz);
extern void     PoolPutLast(npage_t bn);
extern void     PoolPutFirst(npage_t bn);

/*
 * Le Pool est exporte a l'usage du gc : le pool est reconstitue a la
 * fin de celui-ci.
 */

extern npage_t PoolFirst;               /* Point d'entree dans le POOL */
extern npage_t PoolSize;                /* nb pages libres dans le POOL */


extern void     InitBig(npage_t pagenumber, npage_t nb, nregion_t nreg);
