/* $Header: /Nfs/radyr/usr11/rc136/Projet/GC/RCS/monitor.h,v 1.1 1992/09/03 21:14:21 rc136 Exp rc136 $ */
/* Auteur: Vincent Delacour (delacour@poly.polytechnique.fr) */
/* gc.c: tout le gc de K2. */
/* Creation: Sat May 25 15:47:05 1991 */


#ifdef MONITOR_GC
/**********************************************************************
 * Fonctions d'instrumentation
 **********************************************************************/

extern void _report_execution_begins(char *prog); 
extern void _report_execution_ends(void); 
extern void _report_heap(void); 
extern void _report_expansion(void); 
extern void _report_stack(nwords_t nw); 
extern void _report_gc_begins(void); 
extern void _report_gc_ends(void); 
extern void _record_minpool(void); 
extern void _report_minpool(void); 
extern void _report_fixedpages(void); 

extern void _record_obj_locality(val_t);
extern void _report_heap_locality(void);

extern void _report_maxpages(npage_t);
extern void _report_locality_of_references(void);
extern void _report_locality_before(void);

extern void _report_no_locality(void);
extern void _report_init_heap(void);

/**********************************************************************
 * flags : controlent l'appel des fonctions de mesure
 **********************************************************************/

extern int _in_gc;			/* flag */
extern int _gc_monitor_time;		/* perturbe' par le suivant */
extern int _gc_monitor_locality;	/* couteux.  */
extern int _gc_monitor_others;		/* peu couteux */

#endif
