/* $Header: /Nfs/radyr/usr11/rc136/Projet/GC/RCS/gc.h,v 1.1 1992/09/03 21:14:21 rc136 Exp rc136 $ */
/* Auteur: Vincent Delacour (delacour@poly.polytechnique.fr) */

/**********************************************************************
 *                               gc.h
 **********************************************************************/

#define GC_SUCCESS 	0
#define GC_FAIL		1


extern int gc(npage_t);
extern int _gc_count;
extern void InitGC(void);
extern int GCVerbose;

/**********************************************************************
 * Statistiques...
 **********************************************************************
 * Les elements suivants ne sont exportes qu'a l'usage des fonctions
 * d'instrumentation.
 **********************************************************************/

extern nwords_t FreeMem;
extern int GCCount;
extern void* usrstack;


/**********************************************************************
 * Partage avec monitor.c
 **********************************************************************/

#define Ref_P(ref)      (((ulint)(ref) & 1) != 0)

/* Laissons tomber la fiction selon laquelle le gc est, dans son etat */
 /* actuel, independant du schema de taggage... */ 

#define K2INT_(n)		(((long)(n))<<1)
#define CINT_(n)		(((unsigned long)(n))>>1)

/* On va meme faire un petit test, pour eviter les surprises... */

#ifdef K2INT
#	if (K2INT(3) != K2INT_(3)
	    <-- fix that-->
#	endif
#else
# define K2INT(n)	K2INT_(n)
#endif

#ifdef CINT
#	if (CINT(-1) != CINT_(-1)
	    <-- fix that -->
#	endif
#else
# define CINT(n) 	CINT_(n)
#endif

/***********************************************************************
 * FREE-LISTES: DISGUISE/UNDISGUISE
 *
 * Un pointeur "deguise'" est au format immediat. L'utilisation de la
 * macro est hypocrite, puisqu'en pratique on se repose sur un schema
 * de taggage bien determine' (pas paramatrable). Les adresses sont
 * supposees alignees, et donc au format 'immediat' par defaut.
 ***********************************************************************/

#define DISGUISE(p)	(p)
#define UNDISGUISE(p)	(p)


/***********************************************************************
 * bitmaps
 ***********************************************************************/


typedef ulint *bitmap_t;                /* tableau d'entiers non signes */

#define BitMapSize              (PageSize / 32) 

#define MShift(add)             (((ulint)(add) >> 2)  & (32 - 1))
#define MWordNumber(add)        (((ulint)(add) & PageMask) >> 7)
#define MWord(add, bitmap)      (bitmap[MWordNumber((add))])


/* Acces aux descripteurs de pages : les pointeurs de tracage
 * (scavenging pointer) et pointeur vers bitmap sont exclusifs l'un de
 * l'autre. 
 */

#define PageSCP(np)             (PageDescs[(np)].p)
#define RegionSCP(nreg)         (PRegions[(nreg)]->scp)

#define PageBitMap(np)          (PageDescs[(np)].p)

