(* zinc.ml *)

#open "misc";;
#open "modules";;
#open "compiler";;
#open "config";;
#open "filename";;

let banner = "  Camlot: Zinc to K2 Compiler v0.5 -- January 1993\n";;

sys__catch_break true;;
default_used_modules := assoc "cautious" default_used_interfaces;;
load_path := [!path_library];;

let compile s =       
    if check_suffix s ".ml" then
      let filename = chop_suffix s ".ml"
      in compile_implementation (basename filename) filename
    else if check_suffix s ".mli" then
      let filename = chop_suffix s ".mli" in
      compile_intf (basename filename) filename
    else raise (arg__Bad ("don't know what to do with " ^ s))
;;
