(* z2k2.ml *)
(* fichier "main" a linker en dernier *)

#open "misc";;
#open "modules";;
#open "compiler";;
#open "config";;
#open "arg";;
#open "filename";;

let banner = "  Camlot: Zinc to K2 Compiler v0.51 -- July 1993\n";;

(* Parsing de la ligne de commande *)

let main() =
  sys__catch_break true;
  default_used_modules := assoc "cautious" default_used_interfaces;
  load_path := [!path_library];
  let anonymous s =
    if check_suffix s ".ml" then
      let filename = chop_suffix s ".ml"
      in compile_implementation (basename filename) filename
    else if check_suffix s ".mli" then
      let filename = chop_suffix s ".mli" in
      compile_intf (basename filename) filename
    else raise (Bad ("don't know what to do with " ^ s))
  and set_stdlib p =
    path_library := p;
    load_path := [!path_library]
  and add_include d =
    load_path := d :: !load_path
  and open_set set =
    try
      default_used_modules := assoc set default_used_interfaces
    with Not_found ->
      raise (Bad ("unknown module set " ^ set))
  and show_version () = prerr_string banner
  in parse ["-stdlib", String set_stdlib;
            "-I", String add_include;
            "-include", String add_include;
            "-O", String open_set;
            "-open", String open_set;
            "-v", Unit show_version;
            "-version", Unit show_version;
            "-i", Unit (function () -> verbose := true);
            "-", String anonymous]
                anonymous;
     flush std_out;
     exit 0
;;

let z2k2_handler () =
  try 
    main ()
  with Toplevel -> flush std_out;
                   prerr_endline "# toplevel error "; 
                   exit 2
     | sys__Break -> flush std_out;
                     prerr_endline "# break ";
                     exit 3
     | Z2K2 s -> flush std_out;
                 prerr_string "# internal error: "; 
                 prerr_endline s;
                 exit 4
     | arg__Bad s -> flush std_out;
                 prerr_string "# argument error : "; 
                 prerr_endline s;
                 exit 5
;;

printexc__f z2k2_handler ();;
