(* syntax.ml *)

let rec free_vars_of_pat (Pat(desc, _)) =
  match desc with
    Zwildpat -> []
  | Zvarpat v -> [v]
  | Zaliaspat(pat,v) -> v :: free_vars_of_pat pat
  | Zconstantpat _ -> []
  | Zdotpat _ -> []
  | Ztuplepat patl -> flat_map free_vars_of_pat patl
  | Zconstruct0pat(_) -> []
  | Zconstruct1pat(_, pat) -> free_vars_of_pat pat
  | Zorpat(pat1, pat2) -> free_vars_of_pat pat1 @ free_vars_of_pat pat2
  | Zconstraintpat(pat, _) -> free_vars_of_pat pat
  | Zrecordpat lbl_pat_list ->
      flat_map (fun (lbl,pat) -> free_vars_of_pat pat) lbl_pat_list
;;    

let rec expr_is_pure (Expr(desc,loc)) =
  match desc with
    Zident _ -> true
  | Zconstant _ -> true
  | Ztuple el -> for_all expr_is_pure el
  | Zconstruct0 cstr -> true
  | Zconstruct1(cstr,arg) -> expr_is_pure arg
  | Zfunction _ -> true
  | Zconstraint(expr, ty) -> expr_is_pure expr
  | Zvector el -> for_all expr_is_pure el
  | Zrecord lbl_expr_list ->
      for_all (fun (lbl,e) -> expr_is_pure e) lbl_expr_list
  | Zparser _ -> true
  | _ -> false
;;

(*let letdef_is_pure pat_expr_list =
  for_all (fun (pat,expr) -> expr_is_pure expr) pat_expr_list
;;*)
