(*  k2.ml : le langage intermediaire *)

#open "constants";;
#open "hashtable";;
#open "globals";;

type k2ident == string;;

(* Les primitives *)

type primitive =
    Pidentity
  | Ptest of bool_test
  | Pmakeblock of constr_tag
  | Pupdate2 (* pour les streams *)
  | Ptag_of | Pshift_tag
  | Pfield of int
  | Psetfield of int
  | Pccall of string * int
  | Praise
  | Pnot
  | Pnegint | Psuccint | Ppredint
  | Paddint | Psubint | Pmulint | Pdivint | Pmodint
  | Pandint | Porint | Pxorint 
  | Pshiftleftint | Pshiftrightintsigned | Pshiftrightintunsigned
  | Pincr | Pdecr
  | Pintoffloat
  | Pfloatprim of float_primitive
  | Pmakestring | Pstringlength | Pgetstringchar | Psetstringchar
  | Pmakevector | Pvectlength | Pgetvectitem | Psetvectitem | Pbuildvector
  | Pbuildclosure | Pclosurefun | Pbuildtuple 
  | Pstackenv of k2ident * k2exp

and float_primitive =
    Pfloatofint
  | Pnegfloat | Paddfloat | Psubfloat | Pmulfloat | Pdivfloat

and bool_test =
    Peq_test
  | Pnoteq_test
  | Pint_test of int prim_test
  | Pfloat_test of float prim_test
  | Pstring_test of string prim_test
  | Peqtag_test of constr_tag
  | Pnoteqtag_test of constr_tag

and 'a prim_test =
    PTeq
  | PTnoteq
  | PTnoteqimm of 'a
  | PTlt
  | PTle
  | PTgt
  | PTge

and k2exp =
    Kvar of k2ident
  | Kapply of k2ident * k2exp list
  | Kfuncall of k2exp * k2exp list
  | Ksetq of k2ident * k2exp
  | Kif of k2exp * k2exp * k2exp
  | Kblock of k2ident * k2exp list
  | Kreturn of k2ident * k2exp
  | Kthecont
  | Kcont of k2exp * k2exp
  | Klabels of (k2ident * k2ident list * k2exp list) list * k2exp list
  | Klet of (k2ident * k2exp) list * k2exp list
  | Kflet of (k2ident * k2ident list * k2exp list) list * k2exp list
  | Kfunction of k2ident
  | Kprogn of k2exp list
  | Kcase of k2exp * (constr_kind list * k2exp) list * k2exp
  | Kswitch of k2exp * (atomic_constant list * k2exp) list * k2exp
  | Kconst of struct_constant
  | Kintern of struct_constant (* constante a interner *)
  | Kprim of primitive * k2exp list
  | Kvoid  (* valeur inutile *)
;;

type k2def =
    Kdefun of k2ident * k2ident list * k2exp list
  | Kdefvar of k2ident
;;

type k2decl =
    Kstaticfun of k2ident * int
  | Kexternfun of k2ident * int
  | Kstaticvar of k2ident
  | Kexternvar of k2ident
  | Kdecl of string * k2ident list
;;

type k2prog == k2decl hashtable * k2def list;;
      
let new_id = (let h = new_hashtable 97 in 
                fun nom -> nom ^ "@" ^ (string_of_int 
                           (try let cpt = find_in_assoctable h nom
                                in incr cpt; !cpt
                            with Not_found ->
                                 add_to_assoctable h (nom,ref 0);
                                 0)))
;;

let rec new_ids = fun nom 0 -> []
                    | nom n -> (new_id nom) :: (new_ids nom (n-1))
;;

(* Global variables *)

type value_desc =
  { val_typ: typ;                       (* Type *)
    val_prim: prim_desc }               (* Is this a primitive? *)

and prim_desc =
    ValueNotPrim
  | ValuePrim of int * primitive        (* arity & implementation *)
;;
