(* hashtable.mli *)

type 'a hashtable  (* abstract type *)
;;

value new_hashtable : int -> 'a hashtable

  and reset_hashtable : 'a hashtable -> unit
;;

value add_to_hashtable : ('a -> 'b) -> 'a hashtable -> 'a -> unit

  and add_unique_to_hashtable : ('a -> 'b) -> 'a hashtable -> 'a -> unit

  and remove_from_hashtable : ('a -> 'b) -> 'a hashtable -> 'a -> unit

  and find_in_hashtable : ('a -> 'b) -> 'a hashtable -> 'b -> 'a
;;

value do_hashtable : ('a -> unit) -> 'a hashtable -> unit
;;

value add_to_assoctable : ('a * 'b) hashtable -> 'a * 'b -> unit
 
  and add_unique_to_assoctable : ('a * 'b) hashtable -> 'a * 'b -> unit

  and remove_from_assoctable : ('a * 'b) hashtable -> 'a * 'b -> unit

  and find_in_assoctable : ('a * 'b) hashtable -> 'a -> 'b
;;

value add_to_idtable : 'a hashtable -> 'a -> unit
  and add_unique_to_idtable : 'a hashtable -> 'a -> unit
  and remove_from_idtable : 'a hashtable -> 'a -> unit
  and is_in_idtable : 'a hashtable -> 'a -> bool
;;

value insere : 'a -> 'a hashtable -> unit
;;
