(*  front.ml : traduction syntaxe abstraite -> K2 etendu
               Reconnaissance des identificateurs.
               Expansion du pattern matching en tests.
               Propagation des constantes.                              *)
(* version 0.5 *)
(* Regis Cridlig 1991-1993 *)

#open "misc";;
#open "constants";;
#open "globals";;
#open "syntax";;
#open "locations";;
#open "builtins";;
#open "modules";;
#open "k2";;
#open "match";;
#open "prim_decl";;
#open "types";;
#open "queue";;
#open "hashtable";;
#open "tr_env";;
#open "tr_stream";;
#open "type_errors";;

let min x y = if x<y then x else y;;

(*exception Add_Unique;;

let add_unique x queue = iter (fun y -> if x = y then raise Add_Unique) queue;
                         add x queue
;;*)

(* optimisation des fonctions a plusieurs "etages" *)

let rec optimise = function
  Zfunction([]) -> failwith "front:optimise"
| Zfunction(pat_exp_l) ->
    let rec app = function
      (pat_l,Expr(exp,loc))::l -> (pat_l,Expr(optimise exp,loc))::(app l)
    | [] -> []
    and calcule i = function
      (_,Expr(Zfunction((patl,_)::_),_))::l -> 
        calcule (min i (list_length patl)) l
    | _::_ -> 0
    | [] -> i 
    and transforme = fun
      999 _ -> failwith "front:transforme"
    | j (patl,Expr(Zfunction(patlex_l),loc)) -> map (loop loc j patl) patlex_l
      where rec loop loc = fun
        _ p_l ([],ex) -> (p_l,ex)
      | 0 p_l pl_e    -> (p_l,Expr(Zfunction([pl_e]),loc))
      | k p_l (pat::patl,ex) -> loop loc (k-1) (p_l@[pat]) (patl,ex) in
    let p_e_l = app pat_exp_l in
    let mini = calcule 999 p_e_l
    in Zfunction(if mini=0 then p_e_l else flat_map (transforme mini) p_e_l)
| x -> x
;;

(* Gestion de l'environnement local de traduction *)

type local_env =
    Lnullenv
  | Lenv of string * (int * string) * local_env
;;       (* arite et nouveau nom des fn locales *)

let rec search_lenv s = function
    Lenv(ss,info,lenv) -> if s=ss then info else search_lenv s lenv
  | Lnullenv       -> failwith "lenv"
;;

(* Le traducteur des expressions *)

exception Not_constant;;

let extract_constant = function
    Kconst cst -> cst
  |       _    -> raise Not_constant
;;

(*let rec check_letrec_expr (Expr(e,loc)) =
  match e with
    Zident _ -> ()
  | Zconstant _ -> ()
  | Ztuple el -> do_list check_letrec_expr el
  | Zconstruct0 cstr -> ()
  | Zconstruct1(cstr, expr) ->
      check_letrec_expr expr;
      begin match cstr.info.cs_kind with
        Constr_superfluous n ->
          begin match expr with
            Expr(Ztuple _, _) -> ()
          | _ -> illegal_letrec_expr loc
          end
      | _ -> ()
      end
  | Zfunction _ -> ()
  | Zconstraint(e,_) -> check_letrec_expr e
  | Zvector el -> do_list check_letrec_expr el
  | Zrecord lbl_expr_list ->
      do_list (fun (lbl,expr) -> check_letrec_expr expr) lbl_expr_list
  | Zparser _ -> ()
  | Zstream _ -> ()
  | _ ->
      illegal_letrec_expr loc
;;*)

let partial_fun (Loc(start,stop) as loc) tsb =
  let handler =
    Kprim(Praise,
         [Kconst(SCblock(match_failure_tag,
                         [SCatom(ACstring !input_name);
                          SCatom(ACint start);
                          SCatom(ACint stop)]))]) in
  match tsb with
    True ->
      prerr_location loc;
      prerr_begline " Warning: Pattern matching is not exhaustive";
      prerr_endline2 "";
      handler
  | _ ->
      handler
;;

let partial_try s = function (tsb : tristate_logic) -> Kprim(Praise,[Kvar s])
;;

let rec nth_cdr = fun  l    0 -> l
                   | (a::d) n -> nth_cdr d (n-1)
;;

let rec trunc = fun   l    0 -> []
                  | (a::d) n -> a::(trunc d (n-1))
;;

let rec funcall_it = fun exp   []   -> exp
                      |  exp (a::L) -> funcall_it (Kfuncall(exp,a)) L
;;

let fst3 (x,_,_) = x;;

let function_it appel =
  let rec loop = fun
    [] [] -> appel
  | (id::ids) (arg::args) -> Kflet([id,[arg],[loop ids args]],[Kfunction id])
  | _ _  -> fatal_error "function_it"
  in loop 
;;

let defining = ref "" (* global variable being presently defined *)
;;

let rec 
translate_expr env lenv decls defs = (*lenv: env local de fonctions *)
  let rec transl (Expr(desc, loc)) =
  match desc with
    Zident(ref(Zlocal s)) ->
      begin try let (arite,id) = search_lenv s lenv in 
                  if arite=1 then Kfunction id
                  else
                    let lid = new_ids id arite
                    and larg = new_ids "arg" arite
                    in function_it (Kapply(id,map (fun s -> Kvar s) larg)) 
                                   lid larg
            with Failure "lenv" -> translate_access s env
      end
  | Zident(ref(Zglobal g)) ->
      begin match g.info.val_prim with
              ValueNotPrim -> 
                begin (* separer de plus ici extern et static *)
                  match arity_of_fn (g.info.val_typ) with
                    0 -> let id = g.qualid.qual ^ ":" ^ g.qualid.id
                         in if !defining = id then rec_var_err loc;
                            insere (Kexternvar id) decls; Kvar id
                  | _ -> let id = g.qualid.qual ^ ":" ^ g.qualid.id ^ "*1"
                         in insere (Kexternfun(id,1)) decls; Kfunction id
                end
            | ValuePrim(0,p) -> 
                let id = string_of_primitive p 
                in insere (Kdecl("extern obj_t " ^ id ^ ";\n",[])) decls;
                   Kprim(p,[])
            | ValuePrim(arite,p) -> 
                let lid = new_ids (!module_name ^ (string_of_primitive p)) 
                                  arite
                and larg = new_ids "arg" arite
                in function_it(Kprim(p,map (fun s -> Kvar s) larg)) lid larg
       end
  | Zconstant cst -> Kconst cst
  | Ztuple(args) -> 
      let tr_args = map transl args in
      begin 
        try Kconst(SCtuple(map extract_constant tr_args))
        with Not_constant -> Kprim(Pbuildtuple,tr_args)
      end
  | Zconstruct0(c) -> Kconst(SCatom(ACtag(int_of_constr_kind c.info.cs_kind)))
  | Zconstruct1(c,arg) ->
      begin match c.info.cs_kind with
        Constr_constant _ -> failwith "transl: Constr_constant"
      | Constr_regular(tag,_,1) ->
          let tr_arg = transl arg in
          begin match c.info.cs_mut with
                Mutable ->
                  Kprim(Pmakeblock tag, [tr_arg])
              | Notmutable ->
                  begin try
                    Kconst(SCblock(tag,[extract_constant tr_arg]))
                  with Not_constant ->
                    Kprim(Pmakeblock tag, [tr_arg])
                  end
          end
      | Constr_regular(tag,_,n) ->
          begin match arg with
            Expr(Ztuple argl, _) -> (* optimisation *)
              let tr_argl = map transl argl in
              begin match c.info.cs_mut with
                Mutable ->
                  Kprim(Pmakeblock tag, tr_argl)
              | Notmutable ->
                  begin try
                    Kconst(SCblock(tag, map extract_constant tr_argl))
                  with Not_constant ->
                    Kprim(Pmakeblock tag, tr_argl)
                  end
              end
          | _ -> (* cas general *)
              let var = new_id "tuplr" in
              let rec extract_fields i =
                if i >= n then [] else
                  Kprim(Pfield i, [Kvar var]) :: extract_fields (succ i)
              in Klet([(var,transl arg)],
                      [Kprim(Pmakeblock tag, extract_fields 0)])
          end
      | Constr_superfluous -> transl arg
      | Constr_tagless(_,1) -> 
         let tr_arg = transl arg in
          begin match c.info.cs_mut with
                Mutable ->
                  Kprim(Pbuildtuple, [tr_arg])
              | Notmutable ->
                  begin try
                    Kconst(SCtuple [extract_constant tr_arg])
                  with Not_constant ->
                    Kprim(Pbuildtuple, [tr_arg])
                  end
          end
      | Constr_tagless(_,n) ->
         match arg with
            Expr(Ztuple argl, _) -> (* optimisation *)
              let tr_argl = map transl argl in
              begin match c.info.cs_mut with
                Mutable ->
                  Kprim(Pbuildtuple, tr_argl)
              | Notmutable ->
                  begin try
                    Kconst(SCtuple(map extract_constant tr_argl))
                  with Not_constant ->
                    Kprim(Pbuildtuple, tr_argl)
                  end
              end
          | _ -> (* cas general *)
              begin match c.info.cs_mut with
                Mutable ->
                  let var = new_id "tupls" in
                  let rec extract_fields i =
                    if i >= n then [] else
                      Kprim(Pfield i, [Kvar var]) :: extract_fields (succ i)
                  in Klet([(var,transl arg)],
                      [Kprim(Pbuildtuple, extract_fields 0)])
              | Notmutable -> transl arg
              end
      end
(*  | Zapply(Expr(Zparser case_list,loc),[arg]) ->
      (match translate_parser translate_expr lenv decls defs loc env case_list
       with Kflet([_,[id],body],_) ->
         Klet([id, transl arg], body)) *)
(*  | Zapply(Expr(Zparser case_list,loc),_) -> failwith "front: parser" *)
  | Zapply(Expr((Zfunction _) as zf,loc),args) -> 
    (match Expr(optimise zf,loc) with
     Expr(Zfunction ((patl,_):: _ as case_list), _) as funct ->
      let npat = list_length patl
      and narg = list_length args in
        if npat > narg then
          let lid = new_ids (!module_name ^ "func") (npat - narg)
          and vars = new_ids "apply" narg 
          and lvar = new_ids "var" (npat - narg)
          in function_it (Klet(translate_let env lenv decls defs args vars,
                               [translate_match env lenv decls defs 
                                                (partial_fun loc)
                                                case_list (vars@lvar) loc]))
                         lid lvar
        else let vars = new_ids "apply" npat
             in funcall_it
                  (Klet(translate_let env lenv 
                                      decls defs (trunc args npat) vars,
                       [translate_match env lenv decls defs (partial_fun loc)
                                        case_list vars loc]))
                  (map (fun a -> [transl a]) (nth_cdr args npat)))
  | Zapply((Expr(Zident(ref (Zglobal g)), _) as fct), args) ->
      begin
        match g.info.val_prim with
          ValueNotPrim ->
            let narg = list_length args
            and arite = arity_of_fn (g.info.val_typ) in
              if arite >= narg then
                let id = g.qualid.qual ^ ":" ^ g.qualid.id ^ "*" ^
                         (string_of_int narg)
                in insere (Kexternfun(id,narg)) decls; 
                  (* -> separer ici extern et static *)
                   Kapply(id,map transl args)
              else let id = g.qualid.qual ^ ":" ^ g.qualid.id ^ "*" ^ 
                            (string_of_int arite)
                   in insere (Kexternfun(id,arite)) decls;
                (* -> separer ici extern et static *)
                      funcall_it (Kapply(id,map transl (trunc args arite)))
                        (map (fun a -> [transl a]) (nth_cdr args arite))
        | ValuePrim(arity, p) -> 
          let narg = list_length args in
            if arity <= narg then
              funcall_it (Kprim(p, map transl (trunc args arity)))
                         (map (fun a -> [transl a]) (nth_cdr args arity))
            else let lid = new_ids (!module_name ^ (string_of_primitive p))
                                   (arity - narg)
                 and lvar = new_ids "arg" (arity - narg)
                 in function_it (Kprim(p,(map transl args) @
                                         (map (fun s -> Kvar s) lvar)))
                                lid lvar
      end
  | Zapply((Expr(Zident(ref(Zlocal s)),_) as fct), args) ->
      let narg = list_length args
      in begin try
           let (arite,ss) = search_lenv s lenv in
             if arite <= narg then
               funcall_it (Kapply(ss,map transl (trunc args arite)))
                          (map (fun e -> [transl e]) (nth_cdr args arite))
             else let lid = new_ids (!module_name ^ s) (arite - narg)
                  and lvar = new_ids "args" (arite - narg)
                  in function_it (Kapply(ss,(map transl args) @
                                         (map (fun st -> Kvar st) lvar)))
                                 lid lvar
               with Failure "lenv" -> funcall_it (transl fct)
                                        (map (fun e -> [transl e]) args)
         end
  | Zapply(funct, args) -> funcall_it (transl funct)
                                      (map (fun e -> [transl e]) args)
  | Zlet(rec_flag, pat_expr_list, body) ->
     begin
      let (new_lenv,vars,patl,flt) = 
        add_to_lenv lenv [] [] false pat_expr_list
        where rec add_to_lenv lenv lv lpat flet = function 
          (Pat(Zvarpat name,_),Expr(Zfunction(_) as zf,_))::r ->
           (match optimise zf with
             Zfunction((p,_)::_) ->
               add_to_lenv (Lenv(name,(list_length p,
                                    new_id (!module_name ^ name)),lenv)) 
                           lv lpat true r)
(*        | (Pat(Zvarpat name,_),Expr(Zparser(_),_))::r ->
             add_to_lenv (Lenv(name,(1,new_id (!module_name ^ name)),lenv))
                         lv lpat true r *)
        | (pat,_)::r -> 
            let id = new_id "let" 
            in add_to_lenv lenv (id::lv) (pat::lpat) flet r
        | [] -> (lenv,lv,lpat,flet) in
      let tr_body = match vars with
        [] -> [translate_expr env new_lenv decls defs body]
      | _  -> [translate_match env new_lenv decls defs (partial_fun loc) 
                               [patl,body] vars loc]
      in if rec_flag then
           Klabels(translate_rec_bind env new_lenv 
                                      decls defs pat_expr_list loc,
                   tr_body)
         else match (flt,vars) with
                (_,[]) -> Kflet(translate_f_bind env lenv decls defs 
                                                 new_lenv pat_expr_list,
                                tr_body)
              | (false,_) -> 
                  Klet(translate_bind env new_lenv decls defs (rev vars) 
                                      pat_expr_list,tr_body)
              | _ -> Kflet(translate_f_bind env lenv decls defs new_lenv 
                                            pat_expr_list,
                             [Klet(translate_bind env new_lenv decls defs
                                                  (rev vars) 
                                                 pat_expr_list,tr_body)])
     end
  | Zfunction(_::_) as zf -> (match optimise zf with
     Zfunction((patl,_)::_ as case_list) -> 
      let len = list_length patl
      in let ids = new_ids (!module_name ^ "function") len
         and args = new_ids "arg" len
         in translate_fun env lenv decls defs args loc case_list ids args)
  | Zfunction([]) -> failwith "translate_expr"
  | Ztrywith(body, pat_expr_list) ->
      let cont = new_id "cont"
      and res  = new_id "res"
      and id   = new_id (!module_name ^ "try") in
      Klet([cont,Kvar "*handle*"],
        [Kflet([id,[],[Ksetq("*handle*",Kthecont);transl body]],
           [Klet([res,Kapply(id,[])],
              [Ksetq("*handle*",Kvar cont);
               Kif(Kprim(Ptest (Pint_test PTeq),
                           [Kvar "*try*";Kconst(SCatom(ACtag 0))]),
                   Kvar res,
                   Kprogn [Ksetq("*try*",Kconst(SCatom(ACtag 0)));
                           translate_simple_match env lenv decls defs 
                                                  (partial_try res)
                                                  pat_expr_list
                                                  res loc])])])])
  | Zsequence(E1, E2) -> Kprogn [transl E1; transl E2]
  | Zcondition(Eif, Ethen, Eelse) ->
      Kif(transl Eif, transl Ethen, transl Eelse)
  | Zwhile(Econd, Ebody) ->
      let id = new_id (!module_name ^ "while") in
         Klabels([id,[],[Kif ((transl Econd),
                              Kprogn [transl Ebody; Kapply(id,[])],
                              Kvoid)]],
                 [Kapply(id,[])])
  | Zfor(id, Estart, Estop, up_flag, Ebody) ->
       let  stop  = new_id "stop"
       and boucle = new_id (!module_name ^ "for") in
         let test = if up_flag then Kprim(Ptest (Pint_test PTle),
                                          [Kvar id; Kvar stop])
                               else Kprim(Ptest (Pint_test PTge),
                                          [Kvar id; Kvar stop])
         and step = if up_flag 
                    then Kapply(boucle,[Kprim(Psuccint,[Kvar id])])
                    else Kapply(boucle,[Kprim(Ppredint,[Kvar id])])
         and env' = Tenv([id, Path_root id], env)
         in Klet([stop,transl Estop],
              [Klabels([boucle,[id],
                         [Kif (test,
                           Kprogn[translate_expr env' lenv decls defs Ebody;
                                  step],
                           Kvoid)]],
                [Kapply (boucle, [transl Estart])])])
  | Zsequand(E1, E2) ->
      let id = new_id "and" in
        Kif(transl E1,
            Klet([id, transl E2],
              [Kif(Kvar id,Kvar id,Kconst(SCatom(ACtag 0)))]),
            Kconst(SCatom(ACtag 0)))  (* false *)
  | Zsequor(E1, E2) ->
      let id = new_id "or" in
        Klet([id, transl E1],[Kif(Kvar id,Kvar id,transl E2)])
  | Zconstraint(E, _) -> transl E
  | Zvector args ->
      let tr_args = map transl args in
    (*   (try
          Kconst(SCvector(map extract_constant tr_args))
        with Not_constant ->  Pb: un vecteur est mutable !!!) *)
          Kprim(Pbuildvector,tr_args)
  | Zassign(id, E) -> translate_update id env (transl E) (*env=utile!!!*)
  | Zrecord lbl_expr_list ->
      let v = make_vect (list_length lbl_expr_list) Kvoid in
        do_list
          (fun (lbl, e) -> v.(lbl.info.lbl_pos) <- transl e)
          lbl_expr_list;
        begin try
                if for_all (fun (lbl, e) -> lbl.info.lbl_mut == Notmutable)
                           lbl_expr_list
                then Kconst(SCtuple(map_vect_list extract_constant v))
                else raise Not_constant
              with Not_constant ->
                     Kprim(Pbuildtuple,list_of_vect v)
        end
  | Zrecord_access (e, lbl) -> (* pas de tag *)
      Kprim(Pfield lbl.info.lbl_pos, [transl e])
  | Zrecord_update (e1, lbl, e2) -> (* pas de tag *)
      Kprim(Psetfield lbl.info.lbl_pos, [transl e1; transl e2])
  | Zstream stream_comp_list ->
      translate_stream translate_expr env lenv decls defs stream_comp_list
  | Zparser(id,case_list) ->
      translate_parser id translate_expr lenv decls defs loc env case_list
  in transl

and translate_match env lenv decls defs failure_code casel vars loc =
  let transl_action (patlist, expr) = 
    let (new_env, add_lets) = add_pat_list_to_env vars env patlist
    in patlist, add_lets (translate_expr new_env lenv decls defs expr)
  in translate_matching failure_code loc (map transl_action casel) vars

and translate_simple_match env lenv decls defs failure_code pat_expr_list 
                           var loc =
  let transl_action (pat, expr) =
    let (new_env, add_lets) = add_pat_to_env var env pat
    in [pat], add_lets (translate_expr new_env lenv decls defs expr)
  in translate_matching failure_code loc (map transl_action pat_expr_list) 
                        [var]

and translate_fun env lenv decls defs vars loc case_list = fun
       [] [] -> translate_match env lenv decls defs (partial_fun loc) 
                                case_list vars loc
  | (id::ids) (arg::args) ->
      Kflet([id,[arg],
            [translate_fun env lenv decls defs vars loc case_list ids args]],
            [Kfunction id])
  | _ _ -> fatal_error "translate_fun"

and translate_let env lenv decls defs = 
  let rec loop = fun
      []      []    ->  []
  | (a::La) (v::Lv) -> (v,translate_expr env lenv decls defs a) :: loop La Lv
  | _ _ -> fatal_error "translate_let"
  in loop

and translate_bind env lenv decls defs =
  let rec loop = fun
    [] [] -> []
  | vars ((Pat(Zvarpat name,_),Expr(Zfunction _,_)) :: rest) -> 
      loop vars rest
  | (id::vars) ((pat, expr) :: rest) ->
      (id,translate_expr env lenv decls defs expr) :: loop vars rest
  | _ _ -> fatal_error "translate_bind"
  in loop

and translate_f_bind env lenv decls defs new_lenv =
  let rec loop = function
    [] -> []
  | (Pat(Zvarpat name, _), Expr(Zfunction(_) as zf, loc)) :: rest ->
     (match optimise zf with Zfunction(case_list) ->
      let (arite,new_name) = search_lenv name new_lenv in
      let vars = new_ids "f_bind" arite in
        (new_name,vars,
        [translate_match env lenv decls defs (partial_fun loc) case_list 
                         vars loc])
        :: (loop rest))
(*  | (Pat(Zvarpat name,_),Expr(Zparser(case_list), loc)) :: rest ->
      (match translate_parser translate_expr lenv decls defs loc env case_list
        with Kflet([_,[id],body],_) ->
               let (1,new_name) = search_lenv name new_lenv in
                 (new_name,[id],body) :: (loop rest)) *)
  | _ :: rest -> loop rest
  in loop

and translate_rec_bind env lenv decls defs =
  let rec loop = fun
    [] _ -> []
  | ((Pat(Zvarpat name, _), Expr(Zfunction(_) as zf, floc)) :: rest) loc ->
     (match optimise zf with Zfunction(case_list) ->
      let (arite,new_name) = search_lenv name lenv in
      let vars = new_ids "rec_bind" arite in
        (new_name,vars,
         [translate_match env lenv 
                          decls defs (partial_fun floc) case_list vars loc])
        :: (loop rest loc))
(*  | ((Pat(Zvarpat name,_),Expr(Zparser(case_list), floc)) :: rest) loc ->
      (match translate_parser translate_expr lenv decls defs floc env case_list
        with Kflet([_,[id],body],_) ->
               let (1,new_name) = search_lenv name lenv in
                 (new_name,[id],body) :: (loop rest loc)) *)
  | _  loc -> prerr_location loc;
              print_string "Error in recursive definition.";
              print_newline();
              raise Toplevel
  in loop
;;

let translate_expression decls defs exp mod_name = 
  module_name := mod_name ^ ":";
  defining := "";
  translate_expr Tnullenv Lnullenv decls defs exp
;;

let fetch env vars body =
  let rec init = fun
       []      _ -> []
  | (st::lvar) n ->
      (st,Kprim(Pfield n,[Kvar env]))::init lvar (n+1)
  in Klet(init vars 1,body) (* was 0 *)
;;

let defined = ref ((new_hashtable 13) : string hashtable)
;;     (* variables deja definies dans le module *)

let translate_letdef rec_flag decls defs main loc pat_expr_list mod_name =
  let translate_global_bind = function
(*    (Pat(Zvarpat name,_),Expr(Zparser(case_list), loc)) ->
      let lenv = Lnullenv
      and env = Tnullenv in
      (match translate_parser translate_expr lenv decls defs loc env case_list
        with Kflet([_,[id],body],_) ->
               add (Kdefun(name ^ "*1",[id],body)) defs)
  |*) (Pat(Zvarpat i, _), Expr(Zfunction(_) as zf,_)) ->
     (match optimise zf with Zfunction((patl,_):: _ as case_list) ->
      let narg = list_length patl
      and arite = arity_of_fn (find_value_desc (GRname i)).info.val_typ
      and name = !module_name ^ i in
      let vars = new_ids (i ^ "arg") narg
      and id = name ^ "*" ^ (string_of_int narg)
      in add (Kdefun(id,vars,[translate_match Tnullenv Lnullenv decls defs
                                                 (partial_fun loc) 
                                                 case_list vars loc]))
                defs;
         if is_in_idtable !defined name then illegal_double_def loc
         else add_to_idtable !defined name;
         for a=narg-1 downto 1 do 
           let lvar = trunc vars a in
           let kvar = map (fun st -> Kvar st)  lvar
           and env = "*env" ^ (string_of_int a)
           and arg = "*arg" ^ (string_of_int (a+1)) in
           if a < narg-1 then
             add (Kdefun(name ^ (string_of_int a) ^ "*env",[env;arg],
                      [fetch env lvar
                         [Kprim(Pbuildclosure,
                           (Kfunction(name ^ (string_of_int (a+1)) ^ "*env"))
                           ::(kvar@[Kvar arg]))]]))
                    defs
           else add (Kdefun(name ^ (string_of_int a) ^ "*env",[env;arg],
                         [fetch env lvar
                           [Kapply(id,kvar@[Kvar arg])]]))
                       defs;
           add (Kdefun(name ^ "*" ^ (string_of_int a),lvar,
                    [Kprim(Pbuildclosure,
                     (Kfunction(name ^ (string_of_int a) ^ "*env"))::kvar)]))
                  defs
         done;
         for a=narg+1 to arite do
           let lvar = new_ids (i ^ "arg") (a-narg)
           in add(Kdefun(name ^ "*" ^ (string_of_int a),vars@lvar,
                        [funcall_it (Kapply(id,(map (fun i -> Kvar i) vars)))
                                        (map (fun z -> [Kvar z]) lvar)]))
                     defs
         done)
  | (Pat(Zvarpat i, _), expr) -> 
      let id = !module_name ^ i
      and arite = arity_of_fn (find_value_desc (GRname i)).info.val_typ
      in defining := if rec_flag then id else "";
         let k2exp = translate_expr Tnullenv Lnullenv decls defs expr
         in insere (Kexternvar id) decls; (* separer ici extern et static *)
           add (Kdefvar id) defs;  (* inutile si static *)
           if is_in_idtable !defined id then illegal_double_def loc
           else add_to_idtable !defined id;
           add (Ksetq(id,k2exp)) main;  
           for a=1 to arite do
             let lvar = new_ids (i ^ "arg") a
             in add (Kdefun(id ^ "*" ^ (string_of_int a),lvar,
                       [funcall_it (Kvar id) (map (fun z -> [Kvar z]) lvar)]))
                    defs
           done
  | (pat, expr) ->    
    if rec_flag then illegal_letrec_pat loc;
    let id  = new_id "letdef" in
    let (env,add_lets) = add_pat_to_env id Tnullenv pat in
    let vars = free_vars_of_pat pat
    and store_global var = Ksetq(!module_name ^ var,translate_access var env)
    in let action = Kprogn (map store_global vars)
    in add (Klet([id, translate_expression decls defs expr mod_name],
                    [translate_matching (partial_fun loc) loc
                       [[pat],add_lets action] [id]]))  (* Hack *)
           main;    
       do_list 
         (fun i -> 
            let id = !module_name ^ i
            and arite = arity_of_fn (find_value_desc (GRname i)).info.val_typ
            in insere (Kexternvar id) decls;(*separer ici extern et static*) 
               add (Kdefvar id) defs; (* inutile si static *)
               if is_in_idtable !defined id then illegal_double_def loc
               else add_to_idtable !defined id;
               for a=1 to arite do
                 let lvar = new_ids (i ^ "arg") a
                 in add (Kdefun(id ^ "*" ^ (string_of_int a),lvar,
                                [funcall_it (Kvar id) 
                                            (map (fun z -> [Kvar z]) lvar)]))
                      defs (* a modifier comme ci-dessus *)
               done)
         vars  
  in module_name := mod_name ^ ":";
     do_list translate_global_bind pat_expr_list
;;

