#open "misc";;
#open "k2";;
#open "constants";;
#open "globals";;
#open "builtins";;
#open "config";;
#open "queue";;
#open "hashtable";;
#open "obj";;
#open "match";;

(* ecrit.ml : ecrit sur un canal de sortie le programme K2 represente par un
              arbre de syntaxe abstraite. Expanse de plus les primitives de
              Zinc en des macros C.
*)

let offset = 64+8;; (* offset pour les regions de taille fixe *)

type pretty = { mutable compteur: int; (* nb de termes sur la meme ligne *)
                mutable prem : int; (* colonne de depart des premiers termes *)
                suiv : int; (* colonne de depart des termes suivants *)
                mutable ligne : int; (* ligne des 1ers termes *)
                mutable nl : bool}
;;

let mlint i = if boehm then i else 2*i (* tag des entiers *)
;;

(* la fonction d'appel *)
let k2_output (decls,defs,init) extstream module_name =
  let col = ref 0 and ligne = ref 0 and lf = ref false
  and stack = ref [{compteur=0; suiv=0; prem=0; ligne=0; nl=true}] in
  let nl () = output_string extstream "\n"; 
              incr ligne; col := 0; lf := false;
              (hd !stack).nl <- true; () in
  let put s = col := !col + (string_length s); output_string extstream s in
  let align () = 
   let c = (hd !stack).compteur in
    if c > 0 then
      begin
       (hd !stack).compteur <- c-1;
       if (hd !stack).ligne = !ligne & not !lf then put " "
       else begin 
             nl(); (hd !stack).ligne <- !ligne;
             for i=1 to (hd !stack).prem do put " " done 
            end
      end
    else if c = 0 then
           begin nl(); for i=1 to (hd !stack).suiv do put " " done end
         else begin (hd !stack).compteur <- 32000; () end in
  let put_int n = put (string_of_int n) in
  let put_octal n = put_int (n/64); put_int ((n mod 64)/8); put_int (n mod 8)
  and out s = align(); put s in
  let outg s = align(); 
               stack := {nl=false; compteur=-1; prem=!col+1; ligne=!ligne;
                         suiv=0} :: !stack;
               put s  (* parenthese gauche *)
  and out0 s = align(); 
               stack := {nl=true; compteur=0; suiv=!col+2;
                         prem=0; ligne=0} :: !stack;
               put s
  and out1 s = align(); 
               stack := {nl=false; compteur=1; suiv=!col+2; ligne=!ligne;
                         prem=0} :: !stack;
               put s;
               (hd !stack).prem <- !col+1; ()
  and out2 s = align(); 
               stack := {nl=false; compteur=2; suiv=!col+2; ligne=!ligne;
                         prem=0} :: !stack;
               put s;
               (hd !stack).prem <- !col+1; ()
  and out3 s = align(); 
               stack := {nl=false; compteur=3; suiv=!col+2; ligne=!ligne;
                         prem=0} :: !stack;
               put s;
               (hd !stack).prem <- !col+1; ()
  and outz s = align(); 
               stack := {nl=false; compteur=32000; suiv=!col+2; ligne=!ligne;
                         prem=0} :: !stack;
               put s;
               (hd !stack).prem <- !col+1; ()
  and outd s = put s; (* parenthese droite *)
               if (hd !stack).nl then begin lf:=true; () end;
               stack := tl !stack; () in
  let rec put_string s = 
    put "\\\"";
    for i=0 to (string_length s)-1 do put_char(nth_char s i) done;put "\\\"" 
  and put_char c =
      let d = int_of_char c in
        match c with
          `\\` -> put "\\\\"; put_octal d
        | `"`  -> put "\\\\"; put_octal d
        | `$`  -> put "\\\\"; put_octal d
        |   _  -> if (d >= 32) & (d < 128) then
                    begin incr col; output_char extstream c end
                  else begin put "\\\\"; put_octal d end in
  let rec eval_barg larg =
    out1 "(:let"; outg "(";
    let i = ref 0 in
      do_list (fun arg -> incr i; (hd !stack).ligne <- 0;
                          out1 ("(barg" ^ (string_of_int !i));
                          out_exp arg; outd ")")
              larg;
    outd ")"

  and out_exp = function
    Kprim(Pidentity,[arg]) -> out_exp arg
  | Kprim(Pidentity,_) -> failwith "Pidentity"
  | Kprim(Pupdate2,[arg1;arg2]) ->
      outg "(:let ";
      out1 "((block (:expression \"$\""; out_exp arg1; outd "))";
      out1 " (tmp (:expression \"$\""; out_exp arg2; outd ")))";
        out1 "(:if (:test \"$\" tmp)";
         out1 "(:progn ";
         out "(:statement \"*CPTR($)=TAG($)\" block tmp)";
         out "(:statement \"CPTR($)[1]=FIELD($,1)\" block tmp)";
         out "(:statement \"CPTR($)[2]=FIELD($,2)\" block tmp)";
         outd ")";
         out "(:statement \"*CPTR($)=0\" block)";
        outd ")";
      outd ")"
  | Kprim(Pupdate2,_) -> failwith "Pupdate"
  | Kprim(Ptest Peq_test,[arg1;arg2]) -> 
      out2 "(:eq"; out_exp arg1; out_exp arg2; outd ")"
  | Kprim(Ptest Pnoteq_test,[arg1;arg2]) ->
      out2 "(:noteq"; out_exp arg1; out_exp arg2; outd ")"
  | Kprim(Ptest (Pint_test PTeq),[arg1;arg2]) ->
      out2 "(:int_eq"; out_exp arg1; out_exp arg2; outd ")"
  | Kprim(Ptest (Pint_test PTnoteq),[arg1;arg2]) ->
      out2 "(:int_noteq"; out_exp arg1; out_exp arg2; outd ")"
  | Kprim(Ptest (Pint_test (PTnoteqimm arg1)),[arg2]) ->
      out0 "(:test \"MLINT("; put_int arg1; put "L)!=$\""; 
      out_exp arg2; outd ")"
  | Kprim(Ptest (Pint_test PTlt),[arg1;arg2]) ->
      out2 "(:int_lt"; out_exp arg1; out_exp arg2; outd ")"
  | Kprim(Ptest (Pint_test PTle),[arg1;arg2]) ->
      out2 "(:int_le"; out_exp arg1; out_exp arg2; outd ")"
  | Kprim(Ptest (Pint_test PTgt),[arg1;arg2]) ->
      out2 "(:int_gt"; out_exp arg1; out_exp arg2; outd ")"
  | Kprim(Ptest (Pint_test PTge),[arg1;arg2]) ->
      out2 "(:int_ge"; out_exp arg1; out_exp arg2; outd ")"
  | Kprim(Ptest (Pfloat_test PTeq),[arg1;arg2]) ->
      out2 "(:float_eq"; out_exp arg1; out_exp  arg2; outd ")"
  | Kprim(Ptest (Pfloat_test PTnoteq),[arg1;arg2]) ->
      out2 "(:float_noteq"; out_exp arg1; out_exp arg2; outd ")"
  | Kprim(Ptest (Pfloat_test (PTnoteqimm arg1)),[arg2]) ->
      out0 "(:test \""; put (string_of_float arg1);
      put "!=CFLOAT($)\""; out_exp arg2; outd ")"
  | Kprim(Ptest (Pfloat_test PTlt),[arg1;arg2]) ->
      out2 "(:float_lt"; out_exp arg1; out_exp  arg2; outd ")"
  | Kprim(Ptest (Pfloat_test PTle),[arg1;arg2]) ->
      out2 "(:float_le"; out_exp arg1; out_exp  arg2; outd ")"
  | Kprim(Ptest (Pfloat_test PTgt),[arg1;arg2]) ->
      out2 "(:float_gt"; out_exp arg1; out_exp  arg2; outd ")"
  | Kprim(Ptest (Pfloat_test PTge),[arg1;arg2]) ->
      out2 "(:float_ge"; out_exp arg1; out_exp  arg2; outd ")"
  | Kprim(Ptest (Pstring_test PTeq),[arg1;arg2]) ->
      out2 "(:string_eq"; out_exp arg1; out_exp arg2; outd ")"
  | Kprim(Ptest (Pstring_test PTnoteq),[arg1;arg2]) ->
      out2 "(:string_noteq"; out_exp arg1; out_exp arg2; outd ")"
  | Kprim(Ptest (Pstring_test (PTnoteqimm arg1)),[arg2]) ->
      out0 "(:test \"!eqimm_strings("; put_int (string_length arg1); 
      put ",(unsigned char*)"; put_string arg1; put ",$)\""; 
      out_exp arg2; outd ")"
  | Kprim(Ptest (Pstring_test PTlt),[arg1;arg2]) ->
      out2 "(:string_lt"; out_exp arg1; out_exp arg2; outd ")"
  | Kprim(Ptest (Pstring_test PTle),[arg1;arg2]) ->
      out2 "(:string_le"; out_exp arg1; out_exp arg2; outd ")"
  | Kprim(Ptest (Pstring_test PTgt),[arg1;arg2]) ->
      out2 "(:string_gt"; out_exp arg1; out_exp arg2; outd ")"
  | Kprim(Ptest (Pstring_test PTge),[arg1;arg2]) ->
      out2 "(:string_ge"; out_exp arg1; out_exp arg2; outd ")"
  | Kprim(Ptest (Peqtag_test (ConstrExtensible q_id)),[arg]) ->
      let tag = tag_of_string((fst q_id).qual ^ ":" ^ (fst q_id).id)
      in out0 "(:test \""; put_int (mlint tag); put "==TAG($)\"";
         out_exp arg; outd ")"
  | Kprim(Ptest (Pnoteqtag_test (ConstrExtensible q_id)),[arg]) ->
      let tag = tag_of_string((fst q_id).qual ^ ":" ^ (fst q_id).id)
      in out0 "(:test \""; put_int (mlint tag); put "!=TAG($)\"";
         out_exp arg; outd ")"
  | Kprim(Ptest (Peqtag_test (ConstrRegular(_,1))),[arg]) ->
      fatal_error "output (ecrit.ml) : span=1 in Peqtag_test"
  | Kprim(Ptest (Pnoteqtag_test (ConstrRegular(_,1))),[arg]) ->
      fatal_error "output (ecrit.ml) : span=1 in Peqtag_test"
  | Kprim(Ptest (Peqtag_test (ConstrRegular(tag,_))),[arg]) ->
      out0 "(:test \""; put_int (mlint tag); put "==TAG($)\"";
      out_exp arg; outd ")"
  | Kprim(Ptest (Pnoteqtag_test (ConstrRegular(tag,_))),[arg]) ->
      out0 "(:test \""; put_int (mlint tag); put "!=TAG($)\"";
      out_exp arg; outd ")"
  | Kprim(Pmakeblock (ConstrExtensible q_id),larg) ->
      let tag = mlint (tag_of_string((fst q_id).qual ^ ":" ^ (fst q_id).id))
      and i = ref 0
      in eval_barg larg;
         out0 "(:let ((block (:expression \"block_alloc("; 
         put_int (list_length larg); put ")\")))";
         out "(:statement \"*CPTR($)=(obj_t)"; put_int tag; 
         put "\" block)";
         do_list (fun arg ->
                    incr i;
                    out0 "(:statement \"CPTR($)["; put_int !i; 
                    put "]=$\""; out "block barg"; put_int !i; outd ")")
                 larg;
         out "block"; outd ")"; outd ")"
  | Kprim(Pmakeblock (ConstrRegular(tag,_)),[]) ->
(*      out "(:expression \"atom("; put_int (mlint tag); put ")\")"*)
      failwith "Pmakeblock1"
  | Kprim(Pmakeblock (ConstrRegular(_,0)),_) -> failwith "Pmakeblock2"
  | Kprim(Pmakeblock (ConstrRegular(_,1)),larg) ->
(*      let i = ref (-1)
      in eval_barg larg;
         out0 "(:let ((block (:expression \"tuple_alloc("; 
         put_int (list_length larg); put ")\")))";
         do_list (fun arg ->
                    incr i;
                    out0 "(:statement \"CPTR($)["; put_int !i; 
                    put "]=$\""; out "block barg"; put_int (!i+1); outd ")")
                 larg;
         out "block"; outd ")"; outd ")" *)
      failwith "Pmakeblock2"
  | Kprim(Pmakeblock (ConstrRegular(tag,_)),larg) ->
      let i = ref 0
      in eval_barg larg;
         out0 "(:let ((block (:expression \"block_alloc("; 
         put_int (list_length larg); put ")\")))";
         out "(:statement \"*CPTR($)=(obj_t)";
         put_int (mlint tag); 
         put "\" block)";
         do_list (fun arg ->
                    incr i;
                    out0 "(:statement \"CPTR($)["; put_int !i; 
                    put "]=$\""; out "block barg"; put_int !i; outd ")")
                 larg;
         out "block"; outd ")"; outd ")"
  | Kprim(Ptag_of,[arg]) -> (* ne marche que sur un bloc *)
      out1 "(:tag_of"; out_exp arg; outd ")"
  | Kprim(Ptag_of,_) -> failwith "Ptag_of"
  | Kprim(Pshift_tag,[arg]) -> 
      out0 "(:expression \"(MLPTR(CPTR($)+1))\""; out_exp arg; outd ")"
  | Kprim(Pshift_tag,_) -> failwith "Pshift_tag"
  | Kprim(Pfield i,[Kprim(Pshift_tag,[arg])]) -> (* optimisation *)
      out0 "(:expression \"(CPTR($)["; put_int (i+1); put "])\"";
      out_exp arg; outd ")"
  | Kprim(Pfield i,[arg]) -> (* avec ou sans tag *)
      out0 "(:expression \"(CPTR($)["; put_int i; put "])\"";
      out_exp arg; outd ")"
  | Kprim(Pfield _,_) -> failwith "Pfield"
  | Kprim(Psetfield i,[arg1;arg2]) ->
      out0 "(:expression \"(CPTR($)["; put_int i; put "]=$)\"";
      out_exp arg1; out_exp arg2; outd ")"
  | Kprim(Psetfield _,_) -> failwith "output (ecrit.ml) : Psetfield"
  | Kprim(Pccall(id,0),[]) -> out "(:expression \""; put id; put "\")"
  | Kprim(Pccall(name,_),argl) ->
      out0 "(:expression \""; put name; put "(";
      for i=1 to list_length argl - 1 do put "$,"done;
      if argl<>[] then put "$";
      put ")\"";
      do_list (fun arg -> out_exp arg) argl; outd ")"
  | Kprim(Praise,[arg]) ->
      out_exp(Kprogn [Ksetq("*try*",Kconst(SCatom(ACtag 1)));
                      Kcont((Kvar "*handle*"),arg)])
  | Kprim(Praise,_) -> failwith "raise"
  | Kprim(Pnot,[arg]) -> out1 "(:not"; out_exp arg; outd ")"
  | Kprim(Pnot,_) -> failwith "Pnot"
  | Kprim(Pnegint,[arg]) -> out1 "(:negint"; out_exp arg; outd ")"
  | Kprim(Pnegint,_) -> failwith "Pnegint"
  | Kprim(Psuccint,[arg]) -> out1 "(:succint"; out_exp arg; outd ")"
  | Kprim(Psuccint,_) -> failwith "Psuccint"
  | Kprim(Ppredint,[arg]) -> out1 "(:predint"; out_exp arg; outd ")"
  | Kprim(Ppredint,_) -> failwith "Predint"
  | Kprim(Paddint,[arg1;arg2]) -> 
      out2 "(:addint"; out_exp arg1; out_exp arg2; outd ")"
  | Kprim(Paddint,_) -> failwith "Paddint"
  | Kprim(Psubint,[arg1;arg2]) -> 
      out2 "(:subint"; out_exp arg1; out_exp arg2; outd ")" 
  | Kprim(Psubint,_) -> failwith "Psubint"
  | Kprim(Pmulint,[arg1;arg2]) -> 
      out2 "(:mulint"; out_exp arg1; out_exp arg2; outd ")" 
  | Kprim(Pmulint,_) -> failwith "Pmulint"
(*  | Kprim(Pdivint,[arg1;arg2]) ->
      let id = new_id "divint"
      in out_exp (Klet([id,arg2],
                   [Kif(Kprim(Ptest (Pint_test (PTnoteqimm 0)),[Kvar id]),
                        Kprim(PdivC,[arg1;Kvar id]),
                        Kprim(Pccall("division_by_zero",-1,true),[]))])) *)
  | Kprim(Pdivint,[arg1;arg2]) ->
      out2 "(:divint"; out_exp arg1; out_exp arg2; outd ")"  
  | Kprim(Pdivint,_) -> failwith "Pdivint"
(*  | Kprim(Pmodint,[arg1;arg2]) ->
      let id = new_id "modint"
      in out_exp (Klet([id,arg2],
                   [Kif(Kprim(Ptest (Pint_test (PTnoteqimm 0)),[Kvar id]),
                        Kprim(PmodC,[arg1;Kvar id]),
                        Kprim(Pccall("division_by_zero",-1,true),[]))])) *)
  | Kprim(Pmodint,[arg1;arg2]) ->
      out2 "(:modint"; out_exp arg1; out_exp arg2; outd ")"  
  | Kprim(Pmodint,_) -> failwith "Pmodint"
  | Kprim(Pandint,[arg1;arg2]) -> 
      out2 "(:andint"; out_exp arg1; out_exp arg2; outd ")"  
  | Kprim(Pandint,_) -> failwith "Pandint"
  | Kprim(Porint,[arg1;arg2]) -> 
      out2 "(:orint"; out_exp arg1; out_exp arg2; outd ")"   
  | Kprim(Porint,_) -> failwith "Porint"
  | Kprim(Pxorint,[arg1;arg2]) -> 
      out2 "(:xorint"; out_exp arg1; out_exp arg2; outd ")"  
  | Kprim(Pxorint,_) -> failwith "Pxorint"
  | Kprim(Pshiftleftint,[arg1;arg2]) -> 
      out2 "(:shiftleft"; out_exp arg1; out_exp arg2; outd ")" 
  | Kprim(Pshiftleftint,_) -> failwith "Pshiftleftint"
  | Kprim(Pshiftrightintsigned,[arg1;arg2]) -> 
      out2 "(:shiftrightsigned"; out_exp arg1; out_exp arg2; outd ")" 
  | Kprim(Pshiftrightintsigned,_) -> failwith "Pshiftrightintsigned"
  | Kprim(Pshiftrightintunsigned,[arg1;arg2]) -> 
      out2 "(:shiftrightunsigned"; out_exp arg1; out_exp arg2; outd ")" 
  | Kprim(Pshiftrightintunsigned,_) -> failwith "Pshiftrightintunsigned"
  | Kprim(Pincr,[arg]) -> 
      out0 "(:expression \"(*CPTR($)+=MLINT(1))\""; out_exp arg; outd ")"
  | Kprim(Pincr,_) -> failwith "Pincr"
  | Kprim(Pdecr,[arg]) -> 
      out0 "(:expression \"(*CPTR($)-=MLINT(1))\""; out_exp arg; outd ")"
  | Kprim(Pdecr,_) -> failwith "Pdecr"
  | Kprim(Pintoffloat,[arg]) ->
      out1 "(:intoffloat"; out_exp arg; outd ")"
  | Kprim(Pintoffloat,_) -> failwith "Pintoffloat"
  | Kprim(Pfloatprim Pfloatofint,[arg]) ->
      out1 "(:floatofint"; out_exp arg; outd ")"
  | Kprim(Pfloatprim Pnegfloat,[arg]) ->
      out1 "(:negfloat"; out_exp arg; outd ")"
  | Kprim(Pfloatprim Paddfloat,[arg1;arg2]) ->
      out2 "(:addfloat"; out_exp arg1; out_exp arg2; outd ")"
  | Kprim(Pfloatprim Psubfloat,[arg1;arg2]) ->
      out2 "(:subfloat"; out_exp arg1; out_exp arg2; outd ")"
  | Kprim(Pfloatprim Pmulfloat,[arg1;arg2]) ->
      out2 "(:mulfloat"; out_exp arg1; out_exp arg2; outd ")"
  | Kprim(Pfloatprim Pdivfloat,[arg1;arg2]) ->
      out2 "(:divfloat"; out_exp arg1; out_exp arg2; outd ")"
  | Kprim(Pfloatprim _,_) -> failwith "ecrit.ml: Pfloatprim"
  | Kprim(Pmakestring,[len]) ->
      out1 "(:makestring"; out_exp len; outd ")"
  | Kprim(Pmakestring,_) -> failwith "Pmakestring"
  | Kprim(Pstringlength,[arg]) ->
      out1 "(:stringlength"; out_exp arg; outd ")"
  | Kprim(Pstringlength,_) -> failwith "Pstringlength"
  | Kprim(Pgetstringchar,[st;i]) ->
      out2 "(:getstringchar"; out_exp st; out_exp i; outd ")"
  | Kprim(Pgetstringchar,_) -> failwith "output (ecrit.ml) : Pgetstringchar"
  | Kprim(Psetstringchar,[st;i;c]) ->
      out1 "(:setstringchar";
      out_exp st; out_exp i; out_exp c; outd ")"
  | Kprim(Psetstringchar,_) -> failwith "output (ecrit.ml) : Psetstringchar"
  | Kprim(Pmakevector,[len;item]) ->
      out1 "(:makevector"; out_exp len; out_exp item; outd ")"
  | Kprim(Pmakevector,_) -> failwith "output (ecrit.ml) : Pmakevector"
  | Kprim(Pvectlength,[arg]) ->
      out1 "(:vectlength"; out_exp arg; outd ")"
  | Kprim(Pvectlength,_) -> failwith "Pvectlength"
  | Kprim(Pgetvectitem,[v;i]) ->
      out2 "(:getvectitem"; out_exp v; out_exp i; outd ")"
  | Kprim(Pgetvectitem,_) -> failwith "output (ecrit.ml) : Pgetvectitem"
  | Kprim(Psetvectitem,[v;i;item]) ->
      out2 "(:setvectitem";
      out_exp v; out_exp i; out_exp item; outd ")"
  | Kprim(Psetvectitem,_) -> failwith "output (ecrit.ml) : Psetvectitem"
  | Kprim(Pbuildvector,larg) ->
      let i = ref 0
      and len = list_length larg
      in eval_barg larg;
         out0 "(:let ((vector (:expression \"vector_alloc("; 
         put_int len; out ")\")))";
         out "(:statement \"*(CPTR($))=MLINT("; put_int (len+1); 
         put ")\" vector)";
         do_list (fun arg ->
                    incr i;
                    out0 "(:statement \"(CPTR($))["; put_int !i; 
                    put "]=$\""; out "vector barg"; put_int !i; outd ")")
                 larg;
         out "vector"; outd ")"; outd ")"
  | Kprim(Pbuildclosure,larg) -> 
      let i = ref (-1)
      in eval_barg larg;
         out0 "(:let ((closure (:expression \"tuple_alloc("; 
         put_int (list_length larg); put ")\")))";
         do_list (fun arg ->
                    incr i;
                    out0 "(:statement \"(CPTR($))["; put_int !i; 
                    put "]=$\""; out "closure barg"; put_int (!i+1);outd ")")
                 larg;
         out "closure"; outd ")"; outd ")"
  | Kprim(Pclosurefun,[arg]) ->
      out1 "(:closurefun"; out_exp arg; outd ")"
  | Kprim(Pclosurefun,_) -> failwith "Pclosurefun"
(*  | Kprim(Pclosureenv,[arg]) ->
      out1 "(:closureenv"; out_exp arg; outd ")"
  | Kprim(Pclosureenv,_) -> failwith "Pclosureenv" *)
  | Kprim(Pbuildtuple,larg) -> (* alloue un bloc sans tag *)
      let i = ref (-1)
      in eval_barg larg;
         out0 "(:let ((tup (:expression \"tuple_alloc("; 
         put_int (list_length larg); put ")\")))";
         do_list (fun arg ->
                    incr i;
                    out0 "(:statement \"(CPTR($))["; put_int !i; 
                    put "]=$\""; out "tup barg"; put_int (!i+1); outd ")")
                 larg;
         out "tup"; outd ")"; outd ")"
  | Kprim(Pstackenv(idenv,exp),larg) -> (* alloue un environnement local *)
      eval_barg larg; (* reste a ecrire le corps du let *)
      out0("(:stack-allocate ((" ^ idenv ^ " "); 
      put_int (list_length larg); put "))";
      for i=0 to list_length larg - 1 do
        out0("(:statement \"(CPTR($))["); put_int i; 
        put "]=$\""; out(idenv ^ " barg"); put_int (i+1); outd ")"
      done;
      out0("(:statement \"$-=sizeof(obj_t)\" " ^ idenv ^ ")");
      out_exp exp; outd ")"; outd ")"
  | Kvar id -> out id
  | Kapply(id,argl) -> 
      outz ("(" ^ id); 
      do_list (fun arg -> out_exp arg) argl; outd ")"
  | Kfuncall(func,argl) ->
      out1 "(:funcall"; out_exp func;
      do_list (fun arg -> out_exp arg) argl; outd ")"
  | Ksetq(id,exp) -> out1 "(:setq"; out id; out_exp exp; outd ")"
  | Kif(test,th,el) ->
      out1 "(:if"; out_exp test; out_exp th; out_exp el;
      outd ")"
  | Kblock(id,expl) ->
      out1 "(:block"; out id; do_list (fun exp -> out_exp exp) expl;
      outd ")"
  | Kreturn(id,exp) -> 
      out1 "(:return-from"; out id; out_exp exp; outd ")"
  | Kthecont -> out "(:the-continuation)"
  | Kcont(exp1,exp2) -> 
      out1 "(:continue"; out_exp exp1; out_exp exp2; outd ")"
  | Klabels(decl,expl) ->
      out1 "(:labels";  outg "(";
      do_list (fun (id,ids,exps) -> 
                 out1 ("(" ^ id); outg "(";
                 do_list (fun id -> out id) ids; outd ")";
                 do_list (fun exp -> out_exp exp) exps; outd ")" )
             decl; outd ")";
      do_list (fun exp -> out_exp exp) expl; outd ")"
  | Kflet(decl,expl) ->
      out1 "(:flet"; outg "(";
      do_list (fun (id,ids,exps) -> 
                 out1 ("(" ^ id); outg "(";
                 do_list (fun id -> out id) ids; outd ")";
                 do_list (fun exp -> out_exp exp) exps; outd ")" )
             decl;
      outd ")"; do_list (fun exp -> out_exp exp) expl; outd ")"
  | Klet(decl,expl) ->
      out1 "(:let"; outg "("; (hd !stack).ligne <- 0;
      do_list (fun (id,exp) -> out1 ("(" ^ id); out_exp exp; outd ")")
              decl;
      outd ")"; do_list (fun exp -> out_exp exp) expl; outd ")"
  | Kfunction id -> out1 "(:function"; out id; outd ")"
  | Kprogn(expl) ->
      out0 "(:progn"; do_list (fun exp -> out_exp exp) expl; outd ")"
  | Kswitch(exp,(((ACstring _ :: _,_) :: _) as argl),other) ->
      let var = new_id "cases" in
      let rec rec_if = function
        [] -> other
      | ([ACstring s],arg)::args -> 
          Kif(Kprim(Ptest (Pstring_test (PTnoteqimm s)),[Kvar var]),
              rec_if args,arg)
      | _ -> failwith "Kswitch of ACstring"
      in out_exp (Klet([var,exp],[rec_if argl]))
  | Kswitch(exp,(((ACfloat _ :: _,_) :: _) as argl),other) ->
      let var = new_id "casef" in
      let rec rec_if = function
        [] -> other
      | ([ACfloat f],arg)::args -> 
          Kif(Kprim(Ptest (Pfloat_test (PTnoteqimm f)),[Kvar var]),
              rec_if args,arg)
      | _ -> failwith "Kswitch of ACfloat"
      in out_exp (Klet([var,exp],[rec_if argl]))
  | Kswitch(exp,argl,other) ->
      out1 "(:case"; out_exp exp;
      do_list (fun (const_l,exp) -> 
                 outg "("; map out_case_const const_l; out_exp exp; outd ")")
              argl;
(*      if other = Kvoid then failwith "Kswitch: Kvoid"; *)
      out ":otherwise"; out_exp other; outd ")"
  | Kcase(Kvar id,argl,other) -> 
      let superflu = ref [] 
      and tagless  = ref []
      and constant = ref []
      and regular  = ref []
      and const_num = ref 0
      and test = ref false
      in do_list (function ((Constr_constant _ :: _) as constl,_) as cas -> 
                             constant := cas :: !constant;
                             const_num := !const_num + list_length constl
                         | (Constr_regular _ :: _,_) as cas -> 
                             regular := cas :: !regular
                         | ([Constr_superfluous],exp) -> 
                             superflu := exp :: !superflu
                         | ([Constr_tagless _],_) as cas -> 
                             tagless := cas :: !tagless
                         | (Constr_superfluous :: _,_) -> 
                             failwith "Kcase : trop de superfluous"
                         | (Constr_tagless _ :: _,_) -> 
                             failwith "Kcase : tagless"
                         | ([],_) -> failwith "Kcase : nil")
                  argl;
         if !superflu <> [] then
           if other <> Kvoid or list_length argl <> 1
             then failwith "Kcase : superflu"
           else out_exp(hd !superflu)
         else begin 
           if !tagless <> [] & !regular <> [] then failwith "Kcase : error";
           if !constant <> [] & !regular = [] then
            begin
             if !tagless <> [] &
                get_span_of_cs_kind(hd(fst(hd !tagless))) > !const_num + 1 then
              begin (* tester si tag ou bloc *)
               out0 ("(:if (:tagp " ^ id ^ ")");
               out_exp (snd(hd !tagless));
               test := true       
              end;
             out0 ("(:case "^id);
             do_list (function (constr_tag_list,exp) -> 
                        outg "("; (map (function (Constr_constant tag) -> 
                                          out_case_tag tag))
                                       constr_tag_list; 
                                  out_exp exp; outd ")")
                     (rev !constant)
            end
           else if !regular <> [] & !constant = [] then
            begin
             (match !regular with
               (Constr_regular(_,true,_)::_,_) :: _ -> 
                 out0 ("(:case (:tag_of " ^ id ^ ")")
             | (Constr_regular(_,false,_)::_,_) :: _ -> 
                 out0 ("(:case (:tag_or_imm " ^ id ^ ")"));
             do_list (function (constr_tag_list,exp) -> 
                        outg "("; (map (function Constr_regular(tag,_,_) ->
                                          out_case_tag tag))
                                       constr_tag_list;
                                   out_exp exp; outd ")")
                     (rev !regular)
            end
           else 
            begin
             out0 ("(:case (:tag_or_imm " ^ id ^ ")"); (* optimal ?? *)
             do_list (function (constr_tag_list,exp) -> 
                        outg "("; (map (function Constr_regular(tag,_,_) ->
                                          out_case_tag tag))
                                       constr_tag_list;
                                   out_exp exp; outd ")")
                     (rev !regular);
             do_list (function (constr_tag_list,exp) -> 
                        outg "("; (map (function (Constr_constant tag) -> 
                                          out_case_tag tag))
                                       constr_tag_list; 
                                  out_exp exp; outd ")")
                     (rev !constant)
            end;
           out ":otherwise";
           out_exp (match !tagless with
                      [] -> other
                    | [_,exp] -> if !test then other else exp
                    | _ -> failwith "Kcase : trop de constructeurs tagless");
           outd ")"; if !test then outd ")"
          end
  | Kcase(_,_,_) -> failwith "Kcase : not a variable"
  | Kconst const -> out_const const
  | Kintern const -> out "(:expression \"intern_const(\\\""; out_intern const;
                     put "\\\")\")"
  | Kvoid -> out "(:void)"

  and put_word n = 
    if n >= 0 & n < 256 & (n < int_of_char `0` or n > int_of_char `9`) then 
      begin put "\\\\0\\\\0\\\\0"; put_char (char_of_int n) end
    else begin put_char (char_of_int ((lshift_right n 24) land 255));
               put_char (char_of_int ((lshift_right n 16) land 255));
               put_char (char_of_int ((lshift_right n 8) land 255));
               put_char (char_of_int (n land 255))
         end
  and out_atom_intern = function
    ACint i -> put "B"; put_word i
  | ACfloat f -> 
      put "H"; 
      let s = 4*(obj_size (repr f))     (* hack *)
      in for i=s-8 to s-1 do put_char(fstring__nth_char (magic f) i) done
  | ACstring "" -> put "@"; put_char (char_of_int 0)
  | ACstring s ->  
      put "F"; put_word (string_length s);
      for i=0 to (string_length s)-1 do put_char (nth_char s i) done
  | ACtag i -> put "B"; put_word i
  | ACchar c -> put "B"; put_word (int_of_char c)

  and out_intern = function
     SCatom const -> out_atom_intern const
   | SCblock(ConstrExtensible q_id,const_list) ->
       put_char (char_of_int ((list_length const_list) + offset + 1));
       put "B"; 
       put_word (tag_of_string((fst q_id).qual ^ ":" ^ (fst q_id).id));
       do_list (fun c -> out_intern c) const_list
   | SCblock(ConstrRegular(tag,_),[]) -> 
(*       put "@"; put_char (char_of_int tag)  *)
       failwith "out_intern_block"
   | SCblock(ConstrRegular(_,0),_) -> failwith "out_intern_block"
   | SCblock(ConstrRegular(_,1),const_list) -> 
(*       put_char (char_of_int ((list_length const_list) + offset));
       do_list (fun c -> out_intern c) const_list *)
       failwith "out_intern_regular"
   | SCblock(ConstrRegular(tag,_),const_list) -> 
       put_char (char_of_int ((list_length const_list) + offset + 1));
       put "B"; put_word tag;
       do_list (fun c -> out_intern c) const_list
   | SCtuple [] -> failwith "out_intern_tuple"
   | SCtuple const_list ->
      put_char (char_of_int ((list_length const_list) + offset));
      do_list (fun c -> out_intern c) const_list

  and out_case_const = function
    ACint i -> out "\""; put_int (mlint i); put "\""
  | ACtag i -> out "\""; put_int (mlint i); put "\""
  | ACfloat f -> (*out "MLFLOAT("; put (string_of_float f); put ")"*)
                  failwith "out_case_const : float"
  | ACchar c -> out "\""; put_int (mlint (int_of_char c)); put "\""
  | ACstring s -> failwith "out_case_const : string"

  and out_case_tag tag = out_case_const(ACtag (int_of_constr_tag tag))

  and out_atom_const = function
    ACint i -> out "(:expression \"MLINT("; put_int i; put ")\")"
  | ACfloat f ->
      out "(:expression \"MLFLOAT("; put (string_of_float f); put ")\")"
  | ACchar c -> 
      out "(:expression \"MLINT("; put_int (int_of_char c); put ")\")"
  | ACstring s -> 
      out "(:expression \"alloc_string("; put_int (string_length s);
      put ",(unsigned char*)"; put_string s; put ")\")"
  | ACtag i -> out "(:expression \"MLINT("; put_int i; put ")\")"

  and const_barg larg =
    out1 "(:let"; outg "("; (hd !stack).ligne <- 0;
    let i = ref 0 in
      do_list (fun arg -> incr i; out1 ("(barg" ^ (string_of_int !i));
                          out_const arg; outd ")")
              larg;
    outd ")"

  and out_const = function 
     SCatom const -> out_atom_const const
   | SCblock(tag,const_list) -> 
       out_exp (Kprim(Pmakeblock tag,map (fun c -> Kconst c) const_list))
   | SCtuple const_list ->
       out_exp (Kprim(Pbuildtuple, map (fun c -> Kconst c) const_list))

  in (* put "(:declaration \"#include \\\""; put path_include;
     put "zinc.h\\\"\")\n"; *)
     do_hashtable 
       (function Kexternvar id -> put "(:declare :extern :defvar "; 
                                  put id; put ")\n"
               | Kstaticvar id -> put "(:declare :static :defvar "; 
                                  put id; put ")\n"
               | Kexternfun(id,arite) -> 
                   put "(:declare :extern :defun "; put id; put " (";
                   for i=1 to arite do 
                     if i>1 then put " ";
                     put "x"; put_int i done; 
                   put "))\n"
               | Kstaticfun(id,arite) -> 
                   put "(:declare :static :defun "; put id; put " (";
                   for i=1 to arite do 
                     if i>1 then put " ";
                     put "x"; put_int i done;
                   put "))\n"
               | Kdecl(s,idlist) ->
                   put "(:declaration \""; put s; put "\"";
                   do_list (fun id -> put " "; put id) idlist;
                   put ")\n")
        decls;
     iter (function
              Kdefun(name,idl,expl) ->
               out2 "(:defun"; out name; outg "(";
               do_list (fun id -> out id) idl; outd ")";
               if expl=[] then out "(:return-void)"
               else do_list (fun e -> out_exp e) expl;
               outd ")\n"
            | Kdefvar id -> out1 "(:defvar"; out id; outd ")")
          defs;
     out1 "(:defun init_of_"; put module_name; out "()";
     try while true do
           out_exp (take init)
         done
     with Empty -> out "(:return-void)"; outd ")\n";
     if not boehm then 
     begin (* variables definies dans ce module *)
       out1 "(:defun vars_of_"; put module_name; out "()";
       try while true do
             match take defs with
               Kdefvar id -> out1 "(:gcvar "; out id; outd ")"
             | _ -> ()
           done
       with Empty -> ();
       do_hashtable 
         (function Kstaticvar id -> out1 "(:gcvar "; out id; outd ")"
                 | _ -> ())
         decls;
       out "(:return-void)"; outd ")\n"
     end
;;
