(* Constants *)

type qualified_ident =
  { qual: string;
    id: string }
;;

type constr_tag =
    ConstrExtensible of qualified_ident * int(*name of constructor & stamp*)
  | ConstrRegular of int * int          (* tag number & number of constrs *)
;;

type atomic_constant =
    ACint of int
  | ACtag of int  (* tag d'un constructeur *)
  | ACfloat of float
  | ACstring of string
  | ACchar of char

and struct_constant =
    SCatom of atomic_constant
  | SCblock of constr_tag * struct_constant list
  | SCtuple of struct_constant list
;;

value const_unit : struct_constant
;;

value int_of_atom : atomic_constant -> int
  and tag_of_string : string -> int
  and int_of_constr_tag : constr_tag -> int
;;

