(* constants.ml *)

#open "misc";;

let int_of_atom = function
    ACint i -> i
  | ACchar c -> int_of_char c
  | _ -> fatal_error "int_of_atom"
;;

let tag_of_string s = (* hachage des tags d'exceptions *)
  let len = string_length s
  and lim = 10000001
  and base = 93 in
  let rec calcule i sum = 
    if i>=len then sum
    else calcule (i+1) ((sum*base+int_of_char (nth_char s i)) mod lim)
  in calcule 1 len
;;

let int_of_constr_tag = function
    ConstrRegular(i,_) -> i
  | ConstrExtensible(q_id,_) -> tag_of_string(q_id.qual ^ ":" ^ q_id.id)
;;

let const_unit = SCatom(ACtag 0)
;;
