;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: vector -*-
#|
-----------------------------------------------------------------------------------
TITLE: create and ref to vectors
-----------------------------------------------------------------------------------
File:    vector.em
Version: 1.3 (last modification on Tue Jan  4 11:34:51 1994)
State:   published

DESCRIPTION:
make-vector, vector-ref and (setf (vector-ref ..) ..)

DOCUMENTATION:
where an external documentation can be found (filename and format, title of a
paper ...)

NOTES:
remarks about future extensions ...

REQUIRES:
ressources which are used but can't be declared in the import section

PROBLEMS:
known problems or errors that are not yet eliminated

AUTHOR:
Dr. Horst Friedrich

CONTACT: 
Dr. Horst Friedrich

HISTORY: 

31.11.92 creation of this file

Log for /export/home/saturn/ukriegel/Dist/EulispModules/vector.em[1.3]:
  
[1.1] Wed Mar 10 13:13:34 1993 imohr@isst proposed
  [Mon Mar  8 14:36:57 1993] Intention for change:
  Log not inside comments
  - with new file header
  - Log-message inside balanced comment
[1.2] Thu Jun 17 15:22:15 1993 imohr@isst published
  [Thu Jun 17 15:18:36 1993] Intention for change:
  + #module-end
[1.3] Tue Jan  4 11:35:07 1994 wheick@isst published
  [Mon Nov  8 14:28:28 1993] Intention for change:
  complete like 0.99: vectorp equal deep-copy shallow-copy

-----------------------------------------------------------------------------------
|#

#module vector

(import
 (eulisp-kernel
  ;level-0-eulisp
  (only (make-array svref svset vector
                    vectorp
                    equal
                    ) common-lisp)
  copy-generic ; deep-copy shallow-copy
  ) 
 
 syntax 
 (eulisp-kernel 
  (only (defsetf) common-lisp))
 
 export 
 (make-vector make-initialized-vector vector-ref
              vectorp
              equal
              deep-copy
              shallow-copy) ;(setf vector-ref)
 )

(defun make-vector (size)
  (make-array size))

(defmacro make-initialized-vector objs ; *ak*
  `(vector ,@objs))

(defun vector-ref (vec idx)
  (svref vec idx))

(defsetf vector-ref (vec idx) (new-value)
  `(setf (svref ,vec ,idx) ,new-value))

(make-eulisp-class vector array)

(defmethod deep-copy ((vec <vector>))
  (let ((len (length vec)))
    (init-new-vector-deep vec 
                     (make-vector len)
                     len
                     0)))

(defun init-new-vector-deep (source-vec dest-vec len index)
  (if (< index len)
    (progn
      (setf (elt dest-vec index) 
            (deep-copy (elt source-vec index)))
      (init-new-vector-deep source-vec dest-vec len (+ index 1)))
    dest-vec)
  )

(defmethod shallow-copy ((vec <vector>))
  (let ((len (length vec)))
    (init-new-vector vec 
                     (make-vector len)
                     len
                     0))

(defun init-new-vector (source-vec dest-vec len index)
  (if (< index len)
    (progn
      (setf (elt dest-vec index) (elt source-vec index))
      (init-new-vector source-vec dest-vec len (+ index 1)))
    dest-vec)
  )


  )

#module-end
