;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: dynamic075 -*-
#|
-----------------------------------------------------------------------------------
TITLE: EL-in-CL: dynamic bindings for Level1
-----------------------------------------------------------------------------------
File:    dynamic075.em
Version: 1.0 (last modification on Thu Jan 13 10:59:11 1994)
State:   published

DESCRIPTION:

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
Ingo Mohr

CONTACT: 

HISTORY: 
Log for /export/home/saturn/ukriegel/Dist/EulispModules/dynamic075.em[1.0]:
  

-----------------------------------------------------------------------------------
|#

#module dynamic075

(import
 (eulisp-kernel pair symbol null pair-ext)

 syntax 
 (eulisp-kernel
  list-ext
  (only (declare special) common-lisp)
  (rename ((defvar cl:defvar)) common-lisp))
)

;defined macros: defvar dynamic dynamic-let dynamic-setq

(defun make-dynamic-id (id)
(make-eulisp-symbol id))

(defmacro defvar (id init)
`(progn 
   (cl:defvar ,(make-dynamic-id id))
   (setq ,(make-dynamic-id id) ,init)))

(defmacro dynamic (id) (make-dynamic-id id))

(cl:defvar *dynamics* nil)

(defun make-and-collect-dynamic-id (id)
(let ((dyn-id (make-dynamic-id id)))
   (push dyn-id *dynamics*)
   dyn-id))

(defmacro dynamic-let (vars . body)
(let ((*dynamics* nil))
  `(let ,(make-dynamic-let-vars vars)
	(declare (special ,@*dynamics*))
	,@body)))

(defun make-dynamic-let-vars (vars)
(cond ((null vars) nil)
      ((symbolp (car vars))
	 (cons (make-and-collect-dynamic-id (car vars))
	       (make-dynamic-let-vars (cdr vars))))
      (t (cons `(,(make-and-collect-dynamic-id (caar vars)) ,(cadar vars))
	       (make-dynamic-let-vars (cdr vars))))))

(defmacro dynamic-setq (var form)
`(setq ,(make-dynamic-id var) ,form))

#module-end
